<?php
namespace app\modules\glconfig\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_type;
use app\components\WarningHelper;
use app\components\AccessControl;

class QutypemotherController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑题型
	public function actionIndex(){
		$chapterid = $this->request->get("id");
		$chapterid = htmlspecialchars(strip_tags(trim($chapterid)));
		if(empty($chapterid) || is_numeric($chapterid)==false){
			$chapter = new Questi_type();
		}else{
			$chapter = Questi_type::find()->where("id=". $chapterid)->one();
			if(empty($chapter)){
				echo "题型不存在"; die();
			}
		}
		return $this->renderPartial("index", ["chapter"=>$chapter]);
	}
	
	//编辑题型，保存
	public function actionBasicok(){
		$chapterid = $this->request->post("chapterid");
		$chapterid = htmlspecialchars(strip_tags(trim($chapterid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		if(empty($chapterid) || is_numeric($chapterid)==false){
			$chapter = new Questi_type();
		    $chapter->parentid = 0;
			$isnewnode = 1;
		}else{
			$chapter = Questi_type::find()->where("id=". $chapterid)->one();
			$isnewnode = 0;
		}
		$chapter->name = $title;
		$chapter->save();
		if($isnewnode==1){
			$chapter->sortid = $chapter->id*10;
			$chapter->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>