<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Exam;
use app\models\Specialty;
use app\models\Schoolclass;
use app\models\Resour_course;
use app\models\User;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\UserHelper;
use app\components\ResourCourseHelper;
use app\components\SchoolclassHelper;

class BasicController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	private $editstep = "basic";
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//编辑考试
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || !is_numeric($examid)){
			$exam = new Exam();
		}else{
			$exam = Exam::find()->where("id=". $examid)->one();
			if(empty($exam)){
				WarningHelper::warning("考试不存在", ""); die();
			}
			$exam->course = Resour_course::find()->where("id=". $exam->courseid)->one();
			if($this->userobj->roleid!=1){
				if($exam->userid!=$this->userobj->id){
					WarningHelper::warning("无权访问", ""); die();
				}
			}
		}
		$forclasses = [];
		$forclassids = trim($exam->forclass,",");
		if(!empty($forclassids)){
			$forclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $forclassids .")")->all();
		}
		return $this->render("index", ["exam"=>$exam, "forclasses"=>$forclasses, "editstep"=>$this->editstep]);
	}

	//编辑考试，保存
	public function actionBasicok(){
		$examid = $this->request->post("examid");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$forclass = $this->request->post("forclass");
		$forclass = htmlspecialchars(strip_tags(trim($forclass)));
		$begintime = $this->request->post("begintime");
		$begintime = htmlspecialchars(strip_tags(trim($begintime)));
		$endtime = $this->request->post("endtime");
		$endtime = htmlspecialchars(strip_tags(trim($endtime)));
		$points = $this->request->post("points");
		$points = htmlspecialchars(strip_tags(trim($points)));
		$descrip = $this->request->post("descrip");
		$descrip = htmlspecialchars(strip_tags(trim($descrip)));

		if(empty($title)){
			echo json_encode(["code"=>"failed", "msg"=>"请填写考试标题"]);
			die();
		}
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"请选择所属课程"]);
			die();
		}
		if(empty($forclass)){
			echo json_encode(["code"=>"failed", "msg"=>"请选择适用班级"]);
			die();
		}
		if(empty($begintime) || empty($endtime)){
			echo json_encode(["code"=>"failed", "msg"=>"请选择考试时间"]);
			die();
		}
		if(empty($points) || is_numeric($points)==false){
			$points = 100;
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed", "msg"=>"所属课程不存在"]);
			die();
		}
		if(empty($examid) || is_numeric($examid)==false){
			$exam = new Exam();
			$exam->userid = $this->userobj->id;
			$exam->cometime = date("Y-m-d H:i:s");
			$exam->specialid = $course->specialid;
			$exam->courseid = $course->id;
			$exam->specialpath = $course->specialpath;
		}else{
			$exam = Exam::find()->where("id=". $examid)->one();
			if(empty($exam)){
				echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
				die();
			}
			if($this->userobj->roleid!=1){
				if($exam->userid!=$this->userobj->id){
					echo json_encode(["code"=>"failed", "msg"=>"无权访问"]);
					die();
				}
			}
		}
		$forclassids = trim($forclass, ",");
		$persons = User::find()->where("xzclassid in (". $forclassids .")")->count();
		$exam->title = $title;
		$exam->points = $points;
		$exam->begintime = $begintime;
		$exam->endtime = $endtime;
		$exam->forclass = $forclass;
		$exam->descrip = $descrip;
		$exam->persons = $persons;
		$exam->save();
		echo json_encode(["code"=>"success","msg"=>"成功","examid"=>$exam->id]);
	}
		
}
?>