<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_attache;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_attache;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Person_option;
use app\models\Person_stem;
use app\models\Questi_option;
use app\models\Questi_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//考试管理
	public function actionIndex(){
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));

		$se_courseid = $this->request->post("se_courseid");
		$se_courseid = htmlspecialchars(strip_tags(trim($se_courseid)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "isarchived=0";
		if($this->userobj->roleid!=1){
			$condition .= " and userid=". $this->userobj->id;
		}
		if(!empty($se_title)){
			$condition .= " and title like '%". $se_title ."%'";
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_courseid) && is_numeric($se_courseid)){
			$condition .= " and courseid=". $se_courseid;
		}
		$allsize = Exam::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$exams = Exam::find()->select("id,userid,specialid,courseid,title,points,begintime,endtime,ispublish,specialpath,questway,isfreed")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["exams"=>$exams]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			$courses = [];
			if(!empty($se_specialid) && is_numeric($se_specialid)){
				$courses = Resour_course::find()->where("specialid=". $se_specialid)->orderby("spelling asc")->all();
			}
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "courses"=>$courses, "search"=>["se_title"=>$se_title, "se_specialid"=>$se_specialid, "se_courseid"=>$se_courseid]]);
		}
	}

	//发布考试
	public function actionChangeopen(){
		$examid = $this->request->post("examid");
		$ispublish = $this->request->post("ispublish");
		if(empty($examid) || !is_numeric($examid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($ispublish) || !is_numeric($ispublish)){
			$ispublish = 0;
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		$stemnum = Exam_stem::find()->where("examid=". $examid)->count();
		if($stemnum==0 && $exam->questway!=2){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有添加试题"]);
			die();
		}
		$condition = "id=". $examid;
		if($this->userobj->roleid!=1){
			$condition .= " and userid=". $this->userobj->id;
		}
		if($ispublish==1){
			Exam::updateAll(["ispublish"=>1], $condition);
		}else{
			Exam::updateAll(["ispublish"=>0], $condition);
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//删除考试
	public function actionDelete(){
		$examidarr = $this->request->post("examid");
		if(empty($examidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($examidarr as $oneexamid) {
			if(empty($oneexamid) || !is_numeric($oneexamid)){
				$oneexamid = 0;
			}
			$oneexamid = SafetyHelper::KillDangerCode($oneexamid);
			$oneexamid = htmlspecialchars(strip_tags(trim($oneexamid)));
		}
		$examidstr = implode(",", $examidarr);
		$condition = "examid in (". $examidstr .")";
		if($this->userobj->roleid!=1){
			$condition .= " and examid in (select id from exam where userid=". $this->userobj->id .")";
		}
		Doexam_answer::deleteAll($condition);
		Doexam_attache::deleteAll($condition);
		Doexam::deleteAll($condition);
		Exam_attache::deleteAll($condition);
		Exam_option::deleteAll($condition);
		Exam_stem::deleteAll($condition);
		Person_option::deleteAll($condition);
		Person_stem::deleteAll($condition);
		$condition = "id in (". $examidstr .")";
		if($this->userobj->roleid!=1){
			$condition .= " and userid=". $this->userobj->id;
		}
		Exam::deleteAll($condition);
		$qstems = Questi_stem::find()->where("id in (select qbank_stemid from exam_stem where examid in (". $examidstr ."))")->all();
		foreach($qstems as $onestem){
			$onestem->reusage -= 1;
			if($onestem->reusage < 0){
				$onestem->reusage = 0;
			}
			$onestem->save();
		}
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//释放题目
	public function actionChangefree(){
		$examid = $this->request->post("examid");
		$isfreed = $this->request->post("isfreed");
		if(empty($examid) || !is_numeric($examid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($isfreed) || !is_numeric($isfreed)){
			$isfreed = 0;
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		$qstems = Questi_stem::find()->where("id in (select qbank_stemid from exam_stem where examid=". $exam->id .")")->all();
		foreach($qstems as $onestem){
			$onestem->reusage -= 1;
			if($onestem->reusage < 0){
				$onestem->reusage = 0;
			}
			$onestem->save();
		}
		$exam->isfreed = 1;
		$exam->save();
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>