<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Exam;
use app\models\User;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SchoolclassHelper;

class ExportController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
	
	//成绩列表
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$xzclassidstr = trim($exam->forclass, ",");
		$condition = "xzclassid in (". $xzclassidstr .")";		

		$users = User::find()->select("id,username,stdnumber,realname,xzclassid")->where($condition)->orderby("stdnumber asc")->all();
		foreach ($users as $oneuser) {
			$oneuser->doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $oneuser->id)->one();
		}
		return $this->renderPartial("index", ["exam"=>$exam, "users"=>$users]);
	}
		
}
?>