<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Exam;
use app\models\Exam_stem;
use app\models\Exam_option;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\models\Specialty;
use app\models\Resour_course;
use app\models\Schoolclass;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\SafetyHelper;

class ExportpaperController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	private $bigtitle = ["一", "二", "三", "四", "五", "六", "七", "八", "九", "十", "十一", "十二", "十三", "十四", "十五", "十六", "十七", "十八", "十九", "二十"];
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
	
	//导出试卷
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}
		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				echo "无权访问"; die();
			}
		}
		$exam->course = Resour_course::find()->where("id=". $exam->courseid)->one();
		$forclasses = [];
		$forclassids = trim($exam->forclass,",");
		if(!empty($forclassids)){
			$forclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $forclassids .")")->all();
		}
		$forclassnames = "";
		foreach($forclasses as $oneclass){
			$forclassnames .= $oneclass->name .",";
		}
		$forclassnames = trim($forclassnames, ",");
		if(empty($exam->qtypejson)){
			echo "组卷信息丢失，请重新组卷"; die();
		}
		$qtypejson = json_decode($exam->qtypejson);
		foreach($qtypejson as $onetype){
			$onetype->exstems = [];
			if($onetype->questnum>0){
				$onetype->exstems = Exam_stem::find()->where("examid=". $exam->id ." and typechild=". $onetype->id)->orderby("id asc")->all();
				foreach ($onetype->exstems as $onestem) {
					$onestem->options = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id)->orderby("code asc")->all();
				}
			}
		}
		$bigparts = [];
		foreach($qtypejson as $onetype){
			if(!empty($onetype->exstems)){
				$bigparts[] = ["bigtitle"=>$this->bigtitle[count($bigparts)], "typename"=>$onetype->name, "questnum"=>$onetype->questnum, "questpoints"=>$onetype->partpoints, "exstems"=>$onetype->exstems];
			}
		}
		return $this->renderPartial("index", ["exam"=>$exam, "bigparts"=>$bigparts, "forclassnames"=>$forclassnames]);
	}
	
}
?>