<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_onekey;
use app\models\Exam_stem;
use app\models\Specialty;
use app\models\Resour_course;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\SafetyHelper;

class OnekeyController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}

	//一键批改，保存
	public function actionPigaiok(){
		$examid = $this->request->post("examid");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || is_numeric($examid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				echo json_encode(["code"=>"failed", "msg"=>"无权访问"]);
				die();
			}
		}
		$zhuguanti = Exam_stem::find()->where("examid=". $exam->id ." and typeid in (4,5)")->one();
		if(!empty($zhuguanti)){
			echo json_encode(["code"=>"failed", "msg"=>"试卷中有主观题，不能一键批改"]);
			die();
		}
		$rules = Exam_onekey::find()->where("examid=". $exam->id)->orderby("score_lower asc")->all();
		if(empty($rules)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有设置一键批改规则"]);
			die();
		}
		foreach ($rules as $onerule) {
			Doexam::updateAll(["checkerid"=>$this->userobj->id, "checktime"=>date("Y-m-d H:i:s"), "remark"=>$onerule->remark], "examid=". $exam->id ." and isdone=2 and points>=". $onerule->score_lower ." and points<=". $onerule->score_upper);
		}
		Doexam::updateAll(["isdone"=>3], "examid=". $exam->id ." and isdone=2");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>