<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Exam;
use app\models\Exam_onekey;
use app\models\Specialty;
use app\models\Resour_course;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\SafetyHelper;

class OnekeyruleController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	private $editstep = "onekeyrule";
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//一键批改规则
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || !is_numeric($examid)){
			WarningHelper::warning("参数错误", ""); die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			WarningHelper::warning("考试不存在", ""); die();
			if($this->userobj->roleid!=1){
				if($exam->userid!=$this->userobj->id){
					WarningHelper::warning("无权访问", ""); die();
				}
			}
		}
		$exam->course = Resour_course::find()->where("id=". $exam->courseid)->one();
		$rules = Exam_onekey::find()->where("examid=". $exam->id)->orderby("score_lower asc")->all();
		return $this->render("index", ["exam"=>$exam, "rules"=>$rules, "editstep"=>$this->editstep]);
	}

	//一键批改规则，保存
	public function actionBasicok(){
		$examid = $this->request->post("examid");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		$score_lower_arr = $this->request->post("score_lower");
		$score_upper_arr = $this->request->post("score_upper");
		$remark_arr = $this->request->post("remark");
		if(empty($examid) || is_numeric($examid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				echo json_encode(["code"=>"failed", "msg"=>"无权访问"]);
				die();
			}
		}
		Exam_onekey::deleteAll("examid=". $exam->id);
		foreach ($score_lower_arr as $onekey => $onescorelower) {
			$onescoreupper = $score_upper_arr[$onekey];
			$oneremark = $remark_arr[$onekey];
			if(is_numeric($onescorelower) && $onescorelower>=0 && is_numeric($onescoreupper) && $onescoreupper>=0){
				$onerule = new Exam_onekey();
				$onerule->specialid =  $exam->id;
				$onerule->courseid = $exam->courseid;
				$onerule->examid = $exam->id;
				$onerule->score_lower = $onescorelower;
				$onerule->score_upper = $onescoreupper;
				$onerule->remark = $oneremark;
				$onerule->cometime = date("Y-m-d H:i:s");
				$onerule->save();
			}
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>