<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\models\User;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class PigaiController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//试卷管理
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));

		$se_isdone = $this->request->post("se_isdone");
		$se_isdone = htmlspecialchars(strip_tags(trim($se_isdone)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		if(empty($examid) || !is_numeric($examid)){
			WarningHelper::warning("参数错误", "/glexam/default/index"); die();
		}

		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			WarningHelper::warning("考试不存在", "/glexam/default/index"); die();
		}
		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				WarningHelper::warning("无权访问", "/glexam/default/index"); die();
			}
		}

		$xzclassidstr = trim($exam->forclass, ",");
		$condition = "xzclassid in (". $xzclassidstr .")";
		if(!empty($se_title)){
			$condition .= " and (username like '%". $se_title ."%' or stdnumber like '%". $se_title ."%' or realname like '%". $se_title ."%')";
		}
		if(!empty($se_xzclassid) && is_numeric($se_xzclassid)){
			$condition .= " and xzclassid=". $se_xzclassid;
		}
		if($se_isdone==1){
			$condition .= " and id not in (select userid from doexam where examid=". $exam->id ." and isdone in (2,3))";
		}elseif($se_isdone==2){
			$condition .= " and id in (select userid from doexam where examid=". $exam->id ." and isdone in (2))";
		}elseif($se_isdone==3){
			$condition .= " and id in (select userid from doexam where examid=". $exam->id ." and isdone in (3))";
		}
		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$users = User::find()->select("id,username,stdnumber,realname,xzclassid")->where($condition)->orderby("stdnumber asc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			foreach ($users as $oneuser) {
				$oneuser->doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $oneuser->id)->one();
			}
			return $this->renderPartial("pagelist", ["users"=>$users, "exam"=>$exam]);
		}else{
			$xzclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $xzclassidstr .")")->orderby("spelling asc")->all();
			return $this->render("index", ["pager"=>$pager, "exam"=>$exam, "xzclasses"=>$xzclasses, "search"=>["se_title"=>$se_title, "se_xzclassid"=>$se_xzclassid, "se_isdone"=>$se_isdone]]);
		}
	}
		
}
?>