<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\models\User;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class PigaioneController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//批改试卷
	public function actionIndex(){
		$doexid = $this->request->get("id");
		$doexid = htmlspecialchars(strip_tags(trim($doexid)));

		if(empty($doexid) || !is_numeric($doexid)){
			echo "参数错误"; die();
		}

		$doexam = Doexam::find()->where("id=". $doexid)->one();
		if(empty($doexam)){
			echo "学生试卷不存在"; die();
		}

		$exam = Exam::find()->where("id=". $doexam->examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				echo "无权访问"; die();
			}
		}

		$exstems = Exam_stem::find()->where("examid=". $exam->id)->orderby("typechild asc,id asc")->all();
		foreach ($exstems as $onestem) {
			$onestem->options = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id)->orderby("code asc")->all();
			$onestem->doanswer = Doexam_answer::find()->where("examid=". $exam->id ." and stemid=". $onestem->id ." and userid=". $doexam->userid)->one();
			if(empty($onestem->doanswer)){
				$onestem->doanswer = new Doexam_answer();
				$onestem->doanswer->points = 0;
			}
		}
		return $this->renderPartial("index", ["doexam"=>$doexam, "exam"=>$exam, "exstems"=>$exstems]);
	}

	//批改试卷保存
	function actionFinishedok(){
		$examid = $this->request->post("examid");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		$studentid = $this->request->post("studentid");
		$studentid = htmlspecialchars(strip_tags(trim($studentid)));
		$remark = $this->request->post("remark");
		$remark = htmlspecialchars(strip_tags(trim($remark)));
		if(empty($examid) || is_numeric($examid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($studentid) || is_numeric($studentid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误2"]);
			die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		if($this->userobj->roleid!=1){
			if($exam->userid!=$this->userobj->id){
				echo json_encode(["code"=>"failed", "msg"=>"无权访问"]);
				die();
			}
		}
		$exstemidarr = $this->request->post("exstemid");
		$expointsarr = $this->request->post("expoints");
		$doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $studentid)->one();
		if(empty($doexam)){
			echo json_encode(["code"=>"failed", "msg"=>"学生试卷不存在"]);
			die();
		}
		$totalpoints = 0; //总得分
		foreach ($exstemidarr as $onekey => $onestemid) {
			if(empty($expointsarr[$onekey]) || !is_numeric($expointsarr[$onekey])){
				$expointsarr[$onekey] = 0;
			}
			$onestem = Exam_stem::find()->where("id=". $onestemid)->one();
			if(empty($onestem)){continue;}
			$doanswer = Doexam_answer::find()->where("examid=". $examid ." and userid=". $studentid ." and stemid=". $onestemid)->one();
			if(empty($doanswer)){
				$doanswer = new Doexam_answer();
				$doanswer->userid = $studentid;
				$doanswer->examid = $examid;
				$doanswer->stemid = $onestem->id;
				$doanswer->qbank_stemid = $onestem->qbank_stemid;
			}
			$doanswer->points = $expointsarr[$onekey];
			$doanswer->save();
			$totalpoints += $doanswer->points;
		}
		$doexam->isdone = 3;
		$doexam->points = $totalpoints;
		$doexam->checkerid = $this->userobj->id;
		$doexam->checktime = date("Y-m-d H:i:s");
		$doexam->remark = $remark;
		$doexam->save();
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>