<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Exam;
use app\models\Exam_stem;
use app\models\Exam_option;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\models\Specialty;
use app\models\Resour_course;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\SafetyHelper;

class PreviewController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//试题管理
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}
		$exam->course = Resour_course::find()->where("id=". $exam->courseid)->one();
		$exstems = Exam_stem::find()->where("examid=". $exam->id)->orderby("typechild asc,id asc")->all();
		foreach ($exstems as $onestem) {
			$onestem->options = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id)->orderby("code asc")->all();
		}
		return $this->renderPartial("index", ["exam"=>$exam, "exstems"=>$exstems]);
	}
		
}
?>