<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Specialty;
use app\models\Questi_stem;
use app\models\Questi_type;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class QubankController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glexam";
		$this->view->params["navicode_two"] = "glexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
		
	//题目列表
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_username = $this->request->post("se_username");
		$se_username = htmlspecialchars(strip_tags(trim($se_username)));

		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));

		$se_courseid = $this->request->post("se_courseid");
		$se_courseid = htmlspecialchars(strip_tags(trim($se_courseid)));

		$se_treeid = $this->request->post("se_treeid");
		$se_treeid = htmlspecialchars(strip_tags(trim($se_treeid)));
		
		$se_typeid = $this->request->post("se_typeid");
		$se_typeid = htmlspecialchars(strip_tags(trim($se_typeid)));

		$se_levels = $this->request->post("se_levels");
		$se_levels = htmlspecialchars(strip_tags(trim($se_levels)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		if(empty($examid) || !is_numeric($examid)){
			echo '参数错误'; die();
		}

		$condition = "islocked=0 and (maxreusage=0 or reusage<maxreusage)";
		if(!empty($se_title)){
			$condition .= " and content like '%". $se_title ."%'";
		}
		if(!empty($se_username)){
			$condition .= " and userid in (select id from user where realname like '%". $se_username ."%')";
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and specialid=". $se_specialid;
		}
		if(!empty($se_courseid) && is_numeric($se_courseid)){
			$condition .= " and courseid=". $se_courseid;
		}
		if(!empty($se_treeid) && is_numeric($se_treeid)){
			$condition .= " and find_in_set('". $se_treeid ."',treepath)";
		}
		if(!empty($se_typeid) && is_numeric($se_typeid)){
			$condition .= " and typeid=". $se_typeid;
		}
		if(!empty($se_levels) && is_numeric($se_levels)){
			$condition .= " and levels=". $se_levels;
		}
		$allsize = Questi_stem::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$resources = Questi_stem::find()->select("id,userid,typeid,typechild,courseid,treeid,levels,cometime,content")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["resources"=>$resources]);
		}else{
			$colleges = [];
			$courses = [];
			$chapters = [];
			$questitypes = Questi_type::find()->where("parentid>0")->orderby("sortid asc,id asc")->all();
			$colleges = SpecialtyHelper::getCollegelistall();
			if(!empty($se_specialid) && is_numeric($se_specialid)){
				$courses = Resour_course::find()->where("specialid=". $se_specialid)->orderby("spelling asc")->all();
			}
			if(!empty($se_courseid) && is_numeric($se_courseid)){
				$chapters = Resour_tree::find()->where("courseid=". $se_courseid)->orderby("sortid asc,id asc")->all();
				foreach ($chapters as $onechapter) {
					$onechapter->sections = Resour_tree::find()->where("parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
					foreach ($onechapter->sections as $onesection) {
						$onesection->knowledges = Resour_tree::find()->where("parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
					}
				}
			}
			return $this->renderPartial("index", ["pager"=>$pager, "examid"=>$examid, "colleges"=>$colleges, "courses"=>$courses, "chapters"=>$chapters, "questitypes"=>$questitypes, "search"=>["se_title"=>$se_title, "se_username"=>$se_username, "se_specialid"=>$se_specialid, "se_courseid"=>$se_courseid, "se_treeid"=>$se_treeid, "se_typeid"=>$se_typeid, "se_levels"=>$se_levels]]);
		}
	}
		
}
?>