<?php
namespace app\modules\glexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\models\User;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\ExamHelper;
use app\extensions\pager\Pager;

class TongjiController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	private $editstep = "basic";
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
	
	//总体数据
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));

		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		if(empty($se_xzclassid) || !is_numeric($se_xzclassid)){
			$se_xzclassid = 0;
		}

		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$tongji = ExamHelper::CalcExamRatioRight($exam, $se_xzclassid);
		$xzclassidstr = trim($exam->forclass, ",");
		$xzclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $xzclassidstr .")")->orderby("spelling asc")->all();

		return $this->renderPartial("index", ["exam"=>$exam, "tongji"=>$tongji, "xzclasses"=>$xzclasses, "editstep"=>$this->editstep, "search"=>["se_xzclassid"=>$se_xzclassid]]);
	}

	//成绩列表
	public function actionList(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));

		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		if(empty($se_xzclassid) || !is_numeric($se_xzclassid)){
			$se_xzclassid = 0;
		}

		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$xzclassidstr = trim($exam->forclass, ",");
		$condition = "xzclassid in (". $xzclassidstr .")";

		if(!empty($se_xzclassid) && is_numeric($se_xzclassid)){
			$condition .= " and xzclassid=". $se_xzclassid;
		}

		$this->editstep = "list";
		$this->pagesize = 500;

		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();		

		if($listmore=="yes"){
			$users = User::find()->select("id,username,stdnumber,realname,xzclassid")->where($condition)->orderby("stdnumber asc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			foreach ($users as $oneuser) {
				$oneuser->doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $oneuser->id)->one();
			}
			return $this->renderPartial("list_page", ["users"=>$users]);
		}else{
			$xzclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $xzclassidstr .")")->orderby("spelling asc")->all();
			return $this->renderPartial("list", ["pager"=>$pager, "exam"=>$exam, "xzclasses"=>$xzclasses, "editstep"=>$this->editstep, "search"=>["se_title"=>$se_title, "se_xzclassid"=>$se_xzclassid, "se_isdone"=>$se_isdone]]);
		}
	}

	//题目正确率
	public function actionQuestion(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));

		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		if(empty($se_xzclassid) || !is_numeric($se_xzclassid)){
			$se_xzclassid = 0;
		}

		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$xzclassidstr = trim($exam->forclass, ",");
		$xzclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $xzclassidstr .")")->orderby("spelling asc")->all();
		$this->editstep = "question";
		$stems = Exam_stem::find()->select("id,examid,typeid,levels,content")->where("examid=". $exam->id)->orderby("id asc")->all();
		foreach ($stems as $onestem) {
			$onestem->tongji = ExamHelper::CalcQuestionRatioRight($onestem, $se_xzclassid);
		}

		return $this->renderPartial("question", ["exam"=>$exam, "xzclasses"=>$xzclasses, "editstep"=>$this->editstep, "stems"=>$stems, "search"=>["se_xzclassid"=>$se_xzclassid]]);
	}

	//得分区间
	public function actionScore(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));

		if(empty($examid) || !is_numeric($examid)){
			echo "参数错误"; die();
		}
		if(empty($se_xzclassid) || !is_numeric($se_xzclassid)){
			$se_xzclassid = 0;
		}

		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$tongji = ExamHelper::CalcScoreStages($exam, $se_xzclassid);
		$xzclassidstr = trim($exam->forclass, ",");
		$xzclasses = Schoolclass::find()->select("id,name,spelling")->where("id in (". $xzclassidstr .")")->orderby("spelling asc")->all();
		$this->editstep = "score";

		return $this->renderPartial("score", ["exam"=>$exam, "tongji"=>$tongji, "xzclasses"=>$xzclasses, "editstep"=>$this->editstep, "search"=>["se_xzclassid"=>$se_xzclassid]]);
	}
		
}
?>