<?php use app\components\QuestionHelper; ?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title><?php echo $exam->title; ?></title>
  <meta name="renderer" content="webkit">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <meta name="apple-mobile-web-app-status-bar-style" content="black"> 
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="format-detection" content="telephone=no">
  <style>
  body{font-family: '宋体'; color: #000; font-size: 16px;}
  .table{border-collapse:collapse;}
  .table th{padding:2px; border:1px solid #ccc; text-align:center;}
  .table td{padding:2px; border:1px solid #ccc;}
  .table-no-boder{border:none;}
  .table-no-boder th{padding:2px; text-align:center;}
  .table-no-boder td{padding:2px;}
  .paper{line-height: 27px;}
  .quest-stem-content img{
    max-width: 100%;
    max-height: 500px;
  }
  .quest-option-content img{
    max-width: 100%;
    max-height: 500px;
  }
  .quest-answer-content img{
    max-width: 100%;
    max-height: 500px;
  }
  </style>
</head>
<body>

<table class="table">
<tr><td colspan="3">课程名称：<?php echo $exam->course->name; ?></td></tr>
<tr><td colspan="3">适用班级：<?php echo $forclassnames; ?></td></tr>
<tr><td style="width:33%;">考试方式：闭卷</td><td style="width:33%; text-align:right;">年&nbsp;&nbsp;月&nbsp;&nbsp;日</td><td style="width:33%; text-align:right;">共&nbsp;&nbsp;页</td></tr>
</table>

<div style="height: 10px;">&nbsp;</div>

<table class="table">
  <thead>
    <tr>
      <th>题号</th>
      <?php foreach($bigparts as $onepart){ ?>
      <th><?php echo $onepart["bigtitle"]; ?></th>
      <?php } ?>
      <th>总分</th>
      <th>评阅(统分)教师</th>
    </tr> 
  </thead>
  <tbody>
    <tr>
      <td style="text-align: center;">得分</td>
      <?php foreach($bigparts as $onepart){ ?>
      <td>&nbsp;</td>
      <?php } ?>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </tbody>
</table>

<div style="height: 10px;">&nbsp;</div>

<div class="paper">注意事项：</div>
<div class="paper">1、满分 <?php echo $exam->points; ?> 分，要求卷面整洁、字迹工整、无错别字。</div>
<div class="paper">2、考生必须将姓名、班级、考号完整、准确、清楚地填写在试卷规定的地方，否则视为废卷。</div>
<div class="paper">3、考生必须在签到单上签到，若出现遗漏，后果自负。</div>
<div class="paper">4、答案都请写在试卷相应的位置上。</div>

<h1 style="text-align: center;">试&nbsp;&nbsp;题</h1>

<?php foreach($bigparts as $onepart){ ?>
<div style="height: 20px;">&nbsp;</div>
<table class="table" style="width: 200px;">
  <thead>
    <tr>
      <th>得分</th>
      <th>评阅教师</th>
    </tr> 
  </thead>
  <tbody>
    <tr>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </tbody>
</table>

<h3 style="margin-top: 5px; padding-top: 0;"><?php echo $onepart["bigtitle"] ."、". $onepart["typename"] ."（共". $onepart["questnum"] ."题，共". $onepart["questpoints"] ."分，必须将答案填写在答题纸上指定的位置，填错位置不得分）"; ?></h3>

<?php foreach ($onepart["exstems"] as $onekey => $onestem) { ?>
<table class="table-no-boder">
<tr><td width="20"><?php echo $onekey+1; ?>.</td><td class="quest-stem-content"><?php echo htmlspecialchars_decode($onestem->content); ?></td></tr>
</table>
<?php if($onestem->typeid==1 || $onestem->typeid==2){ ?>
<table class="table-no-boder">
<?php foreach ($onestem->options as $oneoption) { ?>
<tr><td width="20">&nbsp;</td><td width="20"><?php echo $oneoption->code .')'; ?></td><td class="quest-option-content"><?php echo htmlspecialchars_decode($oneoption->content); ?></td></tr>
<?php } ?>
</table>
<?php } elseif($onestem->typeid==3){ ?>
<table class="table-no-boder">
<tr><td width="20"></td><td>A)&nbsp;正确</td></tr>
<tr><td width="20"></td><td>B)&nbsp;错误</td></tr>
</table>
<?php } elseif($onestem->typeid==5){ ?>
<div style="height: 50px;">&nbsp;</div>
<?php } ?>

<?php } ?>

<?php } ?>

<hr>

<h1 style="text-align: center;">答&nbsp;&nbsp;案</h1>

<?php foreach($bigparts as $onepart){ ?>
<div style="height: 20px;">&nbsp;</div>

<h3 style="margin-top: 5px; padding-top: 0;"><?php echo $onepart["bigtitle"] ."、". $onepart["typename"]; ?></h3>

<?php foreach ($onepart["exstems"] as $onekey => $onestem) { ?>
<table class="table-no-boder">
<tr><td width="20"><?php echo $onekey+1; ?>.</td><td class="quest-answer-content">
<?php if($onestem->typeid==1 || $onestem->typeid==2){ ?>
<?php echo $onestem->answer; ?>
<?php } elseif($onestem->typeid==3){ ?>
<?php if($onestem->answer=="1"){echo '正确';}else{echo '错误';} ?>
<?php } elseif($onestem->typeid==4){ ?>
<?php foreach ($onestem->options as $oneoptkey => $oneoption) { echo $oneoption->content; if($oneoptkey+1<count($onestem->options)){echo ', ';} } ?>
<?php } elseif($onestem->typeid==5){ ?>
<?php echo htmlspecialchars_decode($onestem->answer); ?>
<?php } ?>
</td></tr>
</table>

<?php } ?>

<?php } ?>

</body>
</html>