<?php
namespace app\modules\glnotice\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Notice;
use app\components\AccessControl;
use app\components\WarningHelper;

class BasicController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["menusubid"] = 170;
		return true;
	}
	
	//编辑公告
	public function actionIndex(){
		$noticeid = $this->request->get("id");
		$noticeid = htmlspecialchars(strip_tags(trim($noticeid)));
		if(empty($noticeid) || !is_numeric($noticeid)){
			$notice = new Notice();
		}else{
			$notice = Notice::find()->where("id=". $noticeid)->one();
			if(empty($notice)){
				WarningHelper::warning("公告不存在", ""); die();
			}
		}
		return $this->render("index", ["notice"=>$notice]);
	}

	//编辑公告，保存
	public function actionBasicok(){
		$noticeid = $this->request->post("noticeid");
		$noticeid = htmlspecialchars(strip_tags(trim($noticeid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$color = $this->request->post("color");
		$color = htmlspecialchars(strip_tags(trim($color)));
		$starttime = $this->request->post("starttime");
		$starttime = htmlspecialchars(strip_tags(trim($starttime)));
		$stoptime = $this->request->post("stoptime");
		$stoptime = htmlspecialchars(strip_tags(trim($stoptime)));
		$content = $this->request->post("content");

		if(empty($title)){
			WarningHelper::warning("标题不能为空",""); die();
		}
		if(empty($color)){
			$color = "";
		}
		if(empty($starttime) || empty($stoptime)){
			WarningHelper::warning("有效期不能为空",""); die();
		}
		if(empty($noticeid) || is_numeric($noticeid)==false){
			$notice = new Notice();
			$notice->userid = $this->userobj->id;
			$notice->cometime = date("Y-m-d H:i:s");
		}else{
			$notice = Notice::find()->where("id=". $noticeid)->one();
			if(empty($notice)){
				WarningHelper::warning("公告不存在",""); die();
			}
		}
		$notice->title = $title;
		$notice->color = $color;
		$notice->starttime = $starttime;
		$notice->stoptime = $stoptime;
		$notice->content = $content;
		$notice->save();
		$this->redirect("/glnotice/default/index.html");
	}
		
}
?>