<?php
namespace app\modules\glnotice\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Notice;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["menusubid"] = 170;
		return true;
	}
	
	public function actionIndex(){
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_isexpiry = $this->request->post("se_isexpiry");
		$se_isexpiry = htmlspecialchars(strip_tags(trim($se_isexpiry)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "missing=0";
		if(!empty($se_title)){
			$condition .= " and title like '%". $se_title ."%'";
		}
		if($se_isexpiry==1){
			$condition .= " and stoptime>'". date("Y-m-d H:i:s") ."'";
		}elseif($se_isexpiry==2){
			$condition .= " and stoptime<='". date("Y-m-d H:i:s") ."'";
		}
		$allsize = Notice::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$notices = Notice::find()->select("id,userid,title,starttime,stoptime,color")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["notices"=>$notices]);
		}else{
			return $this->render("index", ["pager"=>$pager, "search"=>["se_title"=>$se_title, "se_isexpiry"=>$se_isexpiry]]);
		}
	}

	//移动到回收站
	public function actionDelete(){
		$noticeidarr = $this->request->post("noticeid");
		if(empty($noticeidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($noticeidarr as $onenoticeid) {
			if(empty($onenoticeid) || !is_numeric($onenoticeid)){
				$onenoticeid = 0;
			}
			$onenoticeid = SafetyHelper::KillDangerCode($onenoticeid);
			$onenoticeid = htmlspecialchars(strip_tags(trim($onenoticeid)));
		}
		$noticeidstr = implode(",", $noticeidarr);
		Notice::updateAll(["missing"=>1], "id in (". $noticeidstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}
	
}
?>