<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_option;
use app\models\Questi_stem;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\PinyinHelper;

class ChapterController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑章
	public function actionIndex(){
		$chapterid = $this->request->get("id");
		$chapterid = htmlspecialchars(strip_tags(trim($chapterid)));
		if(empty($chapterid) || is_numeric($chapterid)==false){
			$chapter = new Resour_tree();
			$treepath = "";
		}else{
			$chapter = Resour_tree::find()->where("id=". $chapterid)->one();
			if(empty($chapter)){
				echo "章不存在"; die();
			}
			$treepath = $chapter->nodepath;
		}
		return $this->renderPartial("index", ["chapter"=>$chapter, "treepath"=>$treepath]);
	}
	
	//编辑章，保存
	public function actionBasicok(){
		$chapterid = $this->request->post("chapterid");
		$chapterid = htmlspecialchars(strip_tags(trim($chapterid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed","msg"=>"课程不存在"]);
			die();
		}
		if(empty($chapterid) || is_numeric($chapterid)==false){
			$chapter = new Resour_tree();
			$chapter->userid = $this->userobj->id;
			$chapter->specialid = $course->specialid;
		    $chapter->courseid = $course->id;
		    $chapter->parentid = 0;
		    $chapter->nodetype = 1;
			$chapter->cometime = date("Y-m-d H:i:s");
			$isnewnode = 1;
		}else{
			$chapter = Resour_tree::find()->where("id=". $chapterid)->one();
			$isnewnode = 0;
		}
		$pinyin = new PinyinHelper();
		$chapter->name = $title;
		$chapter->spelling = $pinyin->getAllPY($chapter->name);
		if(stripos($chapter->name,"会计")!==false){
			$chapter->spelling = str_ireplace("huiji", "kuaiji", $chapter->spelling);
		}
		$chapter->firstletter = substr($chapter->spelling,0,1);
		$chapter->firstletter = strtoupper($chapter->firstletter);
		$chapter->save();
		if($isnewnode==1){
			$chapter->nodepath = ",". $chapter->id .",";
			$chapter->sortid = $chapter->id*10;
			$chapter->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除章
	public function actionDelete(){
		$chapterid = $this->request->post("chapterid");
		$chapterid = htmlspecialchars(strip_tags(trim($chapterid)));
		if(empty($chapterid) || is_numeric($chapterid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		Questi_option::deleteAll("find_in_set('". $chapterid ."',treepath)");
		Questi_stem::deleteAll("find_in_set('". $chapterid ."',treepath)");
		Resour::deleteAll("find_in_set('". $chapterid ."',treepath)");
		Resour_tree::deleteAll("find_in_set('". $chapterid ."',nodepath) or id=". $chapterid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>