<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_option;
use app\models\Questi_stem;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Specialty;
use app\models\User;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\StringHelper;
use app\components\PinyinHelper;
use app\components\SpecialtyHelper;
use app\components\UserHelper;

class CourseController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑课程
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			$course = new Resour_course();
		}else{
			$course = Resour_course::find()->where("id=". $courseid)->one();
			if(empty($course)){
				echo "课程不存在"; die();
			}
		}
		if(empty($specialid) || is_numeric($specialid)==false){
			$specialid = 0;
		}
		$colleges = SpecialtyHelper::getCollegelistall();
		return $this->renderPartial("index", ["course"=>$course, "colleges"=>$colleges, "specialid"=>$specialid]);
	}
	
	//编辑课程，保存
	public function actionBasicok(){
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$specialid = $this->request->post("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($specialid) || is_numeric($specialid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			echo json_encode(["code"=>"failed","msg"=>"专业不存在"]);
			die();
		}
		if(empty($courseid) || is_numeric($courseid)==false){
			$course = new Resour_course();
			$course->userid = $this->userobj->id;
			$course->cometime = date("Y-m-d H:i:s");
		}else{
			$course = Resour_course::find()->where("id=". $courseid)->one();
		}
		$pinyin = new PinyinHelper();
		$course->specialid = $specialty->id;
		$course->specialpath = $specialty->nodepath;
		$course->name = $title;
		$course->spelling = $pinyin->getAllPY($course->name);
		if(stripos($course->name,"会计")!==false){
			$course->spelling = str_ireplace("huiji", "kuaiji", $course->spelling);
		}
		$course->firstletter = substr($course->spelling,0,1);
		$course->firstletter = strtoupper($course->firstletter);
		$course->save();
		if($this->userobj->roleid!=1){
			$oneleader = Resour_leader::find()->where("courseid=". $course->id)->one();
			if(empty($oneleader)){
				$oneleader = new Resour_leader();
				$oneleader->specialid = $course->specialid;
				$oneleader->courseid = $course->id;
				$oneleader->userid = $this->userobj->id;
				$oneleader->leadertype = 1;
				$oneleader->username = $this->userobj->username;
				$oneleader->stdnumber = $this->userobj->stdnumber;
				$oneleader->realname = $this->userobj->realname;
				$oneleader->logo = $this->userobj->logo;
				$oneleader->save();
			}
		}
		Questi_option::updateAll(["specialid"=>$specialid], "courseid=". $course->id);
		Questi_stem::updateAll(["specialid"=>$specialid], "courseid=". $course->id);
		Resour_tree::updateAll(["specialid"=>$specialid], "courseid=". $course->id);
		$leadcourseidszyk = UserHelper::getLeadCourseIds_zyk($this->userobj->id);
		User::updateAll(["leadcourseidszyk"=>$leadcourseidszyk], "id=". $this->userobj->id);
		AccessControl::RefreshCookie($this->userobj->id);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除课程
	public function actionDelete(){
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed","msg"=>"课程不存在"]);
			die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			echo json_encode(["code"=>"failed","msg"=>"专业不存在"]);
			die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$leadcourseids = $this->userobj->leadcourseidszyk;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false && stripos(",". $leadcourseids .",", ",". $course->id .",")===false){
				echo json_encode(["code"=>"failed","msg"=>"无权访问"]);
				die();
			}
		}
		Questi_option::deleteAll("courseid=". $courseid);
		Questi_stem::deleteAll("courseid=". $courseid);
		Resour_tree::deleteAll("courseid=". $courseid);
		Resour_course::deleteAll("id=". $courseid);
		Resour_leader::deleteAll("courseid=". $courseid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>