<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_stem;
use app\models\Resour_tree;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\JsHelper;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glqcourse";
		$this->view->params["navicode_two"] = "glqcourse_manage";
		$this->view->params["meta_title"] = "课程管理 - ";
		return true;
	}
	
	//课程管理
	public function actionIndex(){
		$se_cateid = $this->request->post("se_cateid");
		$se_cateid = htmlspecialchars(strip_tags(trim($se_cateid)));

		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "nodetype=3";
		if(!empty($se_cateid) && is_numeric($se_cateid)){
			$condition .= " and find_in_set('". $se_cateid ."',nodepath)";
		}
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$condition .= " and id in (". $leadspecialids .")";
		}
		
		$allsize = Specialty::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$specials = Specialty::find()->select("id,name,questinum")->where($condition)->orderby("spelling asc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["specials"=>$specials]);
		}else{
			$colleges = Specialty::find()->select("id,parentid,name,sortid")->where("parentid=0")->orderby("spelling asc")->all();
			foreach($colleges as $onecollege){
				$onecollege->children = Specialty::find()->select("id,parentid,name,sortid")->where("parentid=". $onecollege->id)->orderby("spelling asc")->all();
			}
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "userobj"=>$this->userobj, "search"=>["se_cateid"=>$se_cateid, "se_title"=>$se_title]]);
		}
	}
		
}
?>