<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_option;
use app\models\Questi_stem;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\PinyinHelper;

class KnowledController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑知识点
	public function actionIndex(){
		$knowledid = $this->request->get("id");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		$parentid = $this->request->get("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo "参数错误"; die();
		}
		if(empty($knowledid) || is_numeric($knowledid)==false){
			$knowled = new Resour_tree();
			$knowled->parentid = $parentid;
			$section = Resour_tree::find()->where("id=". $parentid)->one();
			$treepath = $section->nodepath;
		}else{
			$knowled = Resour_tree::find()->where("id=". $knowledid)->one();
			if(empty($knowled)){
				echo "知识点不存在"; die();
			}
			$treepath = $knowled->nodepath;
		}
		return $this->renderPartial("index", ["knowled"=>$knowled, "treepath"=>$treepath]);
	}
	
	//编辑知识点，保存
	public function actionBasicok(){
		$knowledid = $this->request->post("knowledid");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$parentid = $this->request->post("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		if(empty($parentid) || is_numeric($parentid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误2"]);
			die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed","msg"=>"课程不存在"]);
			die();
		}
		$section = Resour_tree::find()->where("id=". $parentid)->one();
		if(empty($section)){
			echo json_encode(["code"=>"failed","msg"=>"节不存在"]);
			die();
		}
		if(empty($knowledid) || is_numeric($knowledid)==false){
			$knowled = new Resour_tree();
			$knowled->userid = $this->userobj->id;
			$knowled->specialid = $course->specialid;
		    $knowled->courseid = $course->id;
		    $knowled->parentid = $section->id;
		    $knowled->nodetype = 3;
			$knowled->cometime = date("Y-m-d H:i:s");
			$isnewnode = 1;
		}else{
			$knowled = Resour_tree::find()->where("id=". $knowledid)->one();
			$isnewnode = 0;
		}
		$pinyin = new PinyinHelper();
		$knowled->name = $title;
		$knowled->spelling = $pinyin->getAllPY($knowled->name);
		if(stripos($knowled->name,"会计")!==false){
			$knowled->spelling = str_ireplace("huiji", "kuaiji", $knowled->spelling);
		}
		$knowled->firstletter = substr($knowled->spelling,0,1);
		$knowled->firstletter = strtoupper($knowled->firstletter);
		$knowled->save();
		if($isnewnode==1){
			$knowled->nodepath = ",". $section->parentid .",". $section->id .",". $knowled->id .",";
			$knowled->sortid = $knowled->id*10;
			$knowled->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除知识点
	public function actionDelete(){
		$knowledid = $this->request->post("knowledid");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		if(empty($knowledid) || is_numeric($knowledid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		Questi_option::deleteAll("find_in_set('". $knowledid ."',treepath)");
		Questi_stem::deleteAll("find_in_set('". $knowledid ."',treepath)");
		Resour::deleteAll("find_in_set('". $knowledid ."',treepath)");
		Resour_tree::deleteAll("find_in_set('". $knowledid ."',nodepath) or id=". $knowledid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>