<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_leader;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\components\UserHelper;

class LeaderController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//团队成员
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			echo '参数错误'; die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo '课程不存在'; die();
		}
		$leaders = Resour_leader::find()->where("courseid=". $courseid)->orderby("leadertype asc")->all();
		$ileadertype = 0;
		$icandoedit = 0;
		if($this->userobj->roleid==1){
			$icandoedit = 1;
		}else{
			foreach ($leaders as $oneleader) {
				if($oneleader->userid==$this->userobj->id){
					$ileadertype = $oneleader->leadertype;
				}
			}
			$leadspecialids = $this->userobj->leadspecialids;
			if(stripos(",". $leadspecialids .",", ",". $course->specialid .",")!==false || $ileadertype==1){
				$icandoedit = 1;
			}
		}		
		return $this->renderPartial("index", ["course"=>$course, "leaders"=>$leaders, "icandoedit"=>$icandoedit]);
	}

	//删除成员
	public function actionDelete(){
		$leaderidarr = $this->request->post("leaderid");
		if(empty($leaderidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($leaderidarr as $oneleaderid) {
			if(empty($oneleaderid) || !is_numeric($oneleaderid)){
				$oneleaderid = 0;
			}
			$oneleaderid = SafetyHelper::KillDangerCode($oneleaderid);
			$oneleaderid = htmlspecialchars(strip_tags(trim($oneleaderid)));
		}
		$leaderidstr = implode(",", $leaderidarr);
		Resour_leader::deleteAll("id in (". $leaderidstr .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//设置负责人
	public function actionChange(){
		$courseid = $this->request->post("courseid");
		$leaderid = $this->request->post("leaderid");
		$leadertype = $this->request->post("leadertype");
		if(empty($courseid) || !is_numeric($courseid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($leaderid) || !is_numeric($leaderid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($leadertype) || !is_numeric($leadertype)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if($leadertype==1){
			Resour_leader::updateAll(["leadertype"=>2], "courseid=". $courseid);
			Resour_leader::updateAll(["leadertype"=>1], "id=". $leaderid);
		}else{
			Resour_leader::updateAll(["leadertype"=>2], "id=". $leaderid);
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>