<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_option;
use app\models\Questi_stem;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\PinyinHelper;

class SectionController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑节
	public function actionIndex(){
		$sectionid = $this->request->get("id");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		$parentid = $this->request->get("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo "参数错误"; die();
		}
		if(empty($sectionid) || is_numeric($sectionid)==false){
			$section = new Resour_tree();
			$section->parentid = $parentid;
			$chapter = Resour_tree::find()->where("id=". $parentid)->one();
			$treepath = $chapter->nodepath;
		}else{
			$section = Resour_tree::find()->where("id=". $sectionid)->one();
			if(empty($section)){
				echo "节不存在"; die();
			}
			$treepath = $section->nodepath;
		}
		return $this->renderPartial("index", ["section"=>$section, "treepath"=>$treepath]);
	}
	
	//编辑节，保存
	public function actionBasicok(){
		$sectionid = $this->request->post("sectionid");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$parentid = $this->request->post("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		if(empty($parentid) || is_numeric($parentid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误2"]);
			die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed","msg"=>"课程不存在"]);
			die();
		}
		$chapter = Resour_tree::find()->where("id=". $parentid)->one();
		if(empty($chapter)){
			echo json_encode(["code"=>"failed","msg"=>"章不存在"]);
			die();
		}
		if(empty($sectionid) || is_numeric($sectionid)==false){
			$section = new Resour_tree();
			$section->userid = $this->userobj->id;
			$section->specialid = $course->specialid;
		    $section->courseid = $course->id;
		    $section->parentid = $chapter->id;
		    $section->nodetype = 2;
			$section->cometime = date("Y-m-d H:i:s");
			$isnewnode = 1;
		}else{
			$section = Resour_tree::find()->where("id=". $sectionid)->one();
			$isnewnode = 0;
		}
		$pinyin = new PinyinHelper();
		$section->name = $title;
		$section->spelling = $pinyin->getAllPY($section->name);
		if(stripos($section->name,"会计")!==false){
			$section->spelling = str_ireplace("huiji", "kuaiji", $section->spelling);
		}
		$section->firstletter = substr($section->spelling,0,1);
		$section->firstletter = strtoupper($section->firstletter);
		$section->save();
		if($isnewnode==1){
			$section->nodepath = ",". $chapter->id .",". $section->id .",";
			$section->sortid = $section->id*10;
			$section->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除节
	public function actionDelete(){
		$sectionid = $this->request->post("sectionid");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		if(empty($sectionid) || is_numeric($sectionid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		Questi_option::deleteAll("find_in_set('". $sectionid ."',treepath)");
		Questi_stem::deleteAll("find_in_set('". $sectionid ."',treepath)");
		Resour::deleteAll("find_in_set('". $sectionid ."',treepath)");
		Resour_tree::deleteAll("find_in_set('". $sectionid ."',nodepath) or id=". $sectionid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>