<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Specialty;
use app\components\UserControl;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class SpecialController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glqcourse";
		$this->view->params["navicode_two"] = "glqcourse_manage";
		$this->view->params["meta_title"] = "课程管理 - ";
		return true;
	}
		
	//资源库课程
	public function actionIndex(){
		$specialid = $this->request->get("id");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($specialid) || is_numeric($specialid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}

		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "specialid=". $specialty->id;
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		$allsize = Resour_course::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$courses = Resour_course::find()->select("id,specialid,name,questinum,isopen")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["courses"=>$courses]);
		}else{
			return $this->render("index", ["specialty"=>$specialty, "pager"=>$pager, "userobj"=>$this->userobj, "search"=>["se_title"=>$se_title]]);
		}
	}
		
}
?>