<?php
namespace app\modules\glqcourse\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Questi_stem;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;

class TreeController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glqcourse";
		$this->view->params["navicode_two"] = "glqcourse_manage";
		$this->view->params["meta_title"] = "课程管理 - ";
		return true;
	}
		
	//知识树
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			WarningHelper::warning("课程不存在",""); die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$leadcourseids = $this->userobj->leadcourseidszyk;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false && stripos(",". $leadcourseids .",", ",". $course->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}
		$chapters = Resour_tree::find()->where("courseid=". $course->id ." and parentid=0")->orderby("sortid asc,id asc")->all();
		foreach ($chapters as $onechapter) {
			$onechapter->sections = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
			foreach ($onechapter->sections as $onesection) {
				$onesection->knowledges = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
			}
		}
		$treepath = $this->request->post("treepath");
		$treepath = htmlspecialchars(strip_tags(trim($treepath)));
		$ileadertype = 0;
		$icandoedit = 1; //开放章节目录编辑功能
		if($this->userobj->roleid==1){
			$icandoedit = 1;
		}else{
			$meleader = Resour_leader::find()->where("courseid=". $course->id ." and userid=". $this->userobj->id)->one();
			if(!empty($meleader)){
				$ileadertype = $meleader->leadertype;
				$this->view->params["navicode_two"] = "glqcourse_myqbank";
			}
			$leadspecialids = $this->userobj->leadspecialids;
			if(stripos(",". $leadspecialids .",", ",". $course->specialid .",")!==false || $ileadertype==1){
				$icandoedit = 1;
			}
		}
		return $this->render("index", ["specialty"=>$specialty, "course"=>$course, "chapters"=>$chapters, "treepath"=>$treepath, "icandoedit"=>$icandoedit]);
	}

	//上下移动章节知识点
	public function actionMoveupdown(){
		$treeid = $this->request->post("treeid");
		$treeid = htmlspecialchars(strip_tags(trim($treeid)));
		$direction = $this->request->post("direction");
		$direction = htmlspecialchars(strip_tags(trim($direction)));
		if(empty($treeid) || is_numeric($treeid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$tree = Resour_tree::find()->where("id=". $treeid)->one();
		if(empty($tree)){
			echo json_encode(["code"=>"failed","msg"=>"节点不存在"]);
			die();
		}
		$brothers = Resour_tree::find()->where("courseid=". $tree->courseid ." and parentid=". $tree->parentid ." and nodetype=". $tree->nodetype)->orderby("sortid asc,id asc")->all();
		foreach($brothers as $onekey => $onebrother){
			$onebrother->sortid = ($onekey+1)*10;
			if($direction=="up"){ //上移
				if($onebrother->id==$tree->id){
					if($onebrother->sortid<15){
						$onebrother->sortid = 1;
					}else{
						$onebrother->sortid -= 15;
					}
				}
			}else{ //下移
				if($onebrother->id==$tree->id){
					$onebrother->sortid += 15;
				}
			}
			$onebrother->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>