<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Questi_stem;
use app\models\Questi_type;
use app\models\Questi_option;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;

class Basic1Controller extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glquesti";
		$this->view->params["navicode_two"] = "glquesti_manage";
		$this->view->params["meta_title"] = "题库管理 - ";
		return true;
	}
		
	//编辑单选题
	public function actionIndex(){
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$treeid = $this->request->post("treeid");
		$treeid = htmlspecialchars(strip_tags(trim($treeid)));
		$stemid = $this->request->post("stemid");
		$stemid = htmlspecialchars(strip_tags(trim($stemid)));
		$typechild = $this->request->post("typechild");
		$typechild = htmlspecialchars(strip_tags(trim($typechild)));
		$listview = $this->request->post("listview");
		$listview = htmlspecialchars(strip_tags(trim($listview)));
		if(empty($courseid) || is_numeric($courseid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			WarningHelper::warning("课程不存在",""); die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$leadcourseids = $this->userobj->leadcourseidszyk;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false && stripos(",". $leadcourseids .",", ",". $course->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}
		if(empty($treeid) || is_numeric($treeid)==false){
			$tree = new Resour_tree();
		}else{
			$tree = Resour_tree::find()->where("id=". $treeid)->one();
		}
		if(empty($stemid) || is_numeric($stemid)==false){
			if(empty($typechild) || !is_numeric($typechild)){
				WarningHelper::warning("题目类型错误",""); die();
			}
			$stem = new Questi_stem();
			$stem->typechild = $typechild;
			$stem->specialid = $course->specialid;
			$stem->courseid = $course->id;
			$stem->treeid = $tree->id;
			$stem->treepath = $tree->nodepath;
			$stem->levels = 1;
		}else{
			$stem = Questi_stem::find()->where("id=". $stemid)->one();
			$stem->options = Questi_option::find()->where("stemid=". $stemid)->orderby("code asc")->all();
		}
		$chapters = Resour_tree::find()->where("courseid=". $course->id ." and parentid=0")->orderby("sortid asc,id asc")->all();
		if(empty($chapters)){
			WarningHelper::warning("课程下没有章节",""); die();
		}
		foreach ($chapters as $onechapter) {
			$onechapter->sections = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
			foreach ($onechapter->sections as $onesection) {
				$onesection->knowledges = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
			}
		}
		if($this->userobj->roleid!=1){
			$meleader = Resour_leader::find()->where("courseid=". $course->id ." and userid=". $this->userobj->id)->one();
			if(!empty($meleader)){
				$this->view->params["navicode_two"] = "glquesti_myqbank";
			}
		}
		return $this->render("index", ["specialty"=>$specialty, "course"=>$course, "tree"=>$tree, "chapters"=>$chapters, "stem"=>$stem, "listview"=>$listview]);
	}

	//增加选项
	public function actionOptionadd(){
		$lastcodeindex = $this->request->post("lastcodeindex");
		$lastcodeindex = htmlspecialchars(strip_tags(trim($lastcodeindex)));
		if(is_numeric($lastcodeindex)==false || $lastcodeindex<-1){
			echo '参数错误'; die();
		}
		$lastcodeindex = intval($lastcodeindex);
		if($lastcodeindex>=Yii::$app->params["questmaxoption"]){
			echo '题目选项最多为'. Yii::$app->params["questmaxoption"] .'个'; die();
		}
		$optioncodearr = explode(",", Yii::$app->params["en_letters"]);
		$nextcodeletter = $optioncodearr[$lastcodeindex+1];
		return $this->renderPartial("optionadd", ["nextcodeletter"=>$nextcodeletter]);
	}

	//编辑单选题，保存
	public function actionBasicok(){
		$courseid = $this->request->post("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$treeid = $this->request->post("treeid");
		$treeid = htmlspecialchars(strip_tags(trim($treeid)));
		$stemid = $this->request->post("stemid");
		$stemid = htmlspecialchars(strip_tags(trim($stemid)));
		$typechild = $this->request->post("typechild");
		$typechild = htmlspecialchars(strip_tags(trim($typechild)));
		$levels = $this->request->post("levels");
		$levels = htmlspecialchars(strip_tags(trim($levels)));
		$content = $this->request->post("content");
		$content = trim($content);
		$explains = $this->request->post("explains");
		$explains = trim($explains);
		$answercode = $this->request->post("answercode");
		$answercode = htmlspecialchars(strip_tags(trim($answercode)));
		$optioncode = $this->request->post("optioncode");
		$optioncontent = $this->request->post("optioncontent");
		$listview = $this->request->post("listview");
		$listview = htmlspecialchars(strip_tags(trim($listview)));
		if(empty($typechild) || !is_numeric($typechild)){
			echo json_encode(["code"=>"failed", "msg"=>"题目类型错误"]); die();
		}
		$questtype = Questi_type::find()->where("id=". $typechild)->one();
		if(empty($questtype)){
			echo json_encode(["code"=>"failed", "msg"=>"题目类型不存在"]); die();
		}
		$typeid = $questtype->parentid;
		if(empty($courseid) || is_numeric($courseid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"课程参数错误"]); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed", "msg"=>"课程不存在"]); die();
		}
		if(empty($treeid) || is_numeric($treeid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"所属知识点错误"]); die();
		}
		$tree = Resour_tree::find()->where("id=". $treeid)->one();
		if(empty($tree)){
			echo json_encode(["code"=>"failed", "msg"=>"所属知识点不存在"]); die();
		}
		if(empty($stemid) || is_numeric($stemid)==false){
			$stem = new Questi_stem();
			$stem->userid = $this->userobj->id;
			$stem->typeid = $typeid;
			$stem->typechild = $typechild;
			$stem->specialid = $course->specialid;
			$stem->courseid = $course->id;
			$stem->cometime = date("Y-m-d H:i:s");
		}else{
			$stem = Questi_stem::find()->where("id=". $stemid)->one();
		}
		$stem->treeid = $tree->id;
		$stem->treepath = $tree->nodepath;
		$stem->optionnum = count($optioncode);
		$stem->levels = $levels;
		$stem->content = $content;
		$stem->answer = $answercode;
		$stem->explains = $explains;
		$stem->save();
		Questi_option::deleteAll("stemid=". $stem->id);
		foreach ($optioncode as $oneindex => $onecode) {
			$oneoption = new Questi_option();
			$oneoption->userid = $this->userobj->id;
			$oneoption->typeid = $stem->typeid;
			$oneoption->typechild = $stem->typechild;
			$oneoption->specialid = $course->specialid;
			$oneoption->courseid = $course->id;
			$oneoption->treeid = $tree->id;
			$oneoption->treepath = $tree->nodepath;
			$oneoption->stemid = $stem->id;
			$oneoption->code = $onecode;
			if($onecode==$answercode){ $oneoption->isanswer = 1; }
			$oneoption->content = $optioncontent[$oneindex];
			$oneoption->save();
		}
		Questi_stem::updateAll(["maxreusage"=>$course->reusage], "courseid=". $course->id);
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}
		
}
?>