<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Questi_stem;
use app\models\Questi_type;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;

class BasicController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑题目
	public function actionIndex(){
		$stemid = $this->request->get("stemid");
		$stemid = htmlspecialchars(strip_tags(trim($stemid)));
		if(!empty($stemid) & is_numeric($stemid)){
			$stem = Questi_stem::find()->where("id=". $stemid)->one();
			if(empty($stem)){
				echo '题目不存在';
				die();
			}
		}else{
			$stem = new Questi_stem();
			$stem->typeid = 1;
			$stem->typechild = 6;
		}
		$stemtypes = Questi_type::find()->where("parentid>0")->all();
		return $this->renderPartial("index", ["stemtypes"=>$stemtypes, "stem"=>$stem]);
	}
		
}
?>