<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_stem;
use app\models\Resour_tree;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\JsHelper;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glquesti";
		$this->view->params["navicode_two"] = "glquesti_manage";
		$this->view->params["meta_title"] = "题库管理 - ";
		return true;
	}
	
	//题库管理
	public function actionIndex(){
		$se_cateid = $this->request->post("se_cateid");
		$se_cateid = htmlspecialchars(strip_tags(trim($se_cateid)));

		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "nodetype=3";
		if(!empty($se_cateid) && is_numeric($se_cateid)){
			$condition .= " and find_in_set('". $se_cateid ."',nodepath)";
		}
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$condition .= " and id in (". $leadspecialids .")";
		}
		
		$allsize = Specialty::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$specials = Specialty::find()->select("id,name,questinum")->where($condition)->orderby("spelling asc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["specials"=>$specials]);
		}else{
			$colleges = Specialty::find()->select("id,parentid,name,sortid")->where("parentid=0")->orderby("spelling asc")->all();
			foreach($colleges as $onecollege){
				$onecollege->children = Specialty::find()->select("id,parentid,name,sortid")->where("parentid=". $onecollege->id)->orderby("spelling asc")->all();
			}
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "userobj"=>$this->userobj, "search"=>["se_cateid"=>$se_cateid, "se_title"=>$se_title]]);
		}
	}

	//统计各专业题目数量
	public function actionCalcquestinum(){
		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		$courseid = $this->request->get("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$dbh = Yii::$app->db;
		$sql = "update specialty set questinum=(select count(*) from questi_stem where questi_stem.specialid=specialty.id) where nodetype=3";
		if(!empty($specialid) && is_numeric($specialid)){
			$sql .= " and id=". $specialid;
		}
		$sql .= ";update specialty set questinum=0 where questinum is null;";
		$cmd = $dbh->createCommand($sql);
		$cmd->execute();
		$sql = "update resour_course set questinum=(select count(*) from questi_stem where questi_stem.courseid=resour_course.id) where 1=1";
		if(!empty($courseid) && is_numeric($courseid)){
			$sql .= " and id=". $courseid;
		}
		$sql .= ";update resour_course set questinum=0 where questinum is null;";
		$cmd = $dbh->createCommand($sql);
		$cmd->execute();
		$js = new JsHelper();
		$rnum = date("YmdHis") . rand(10000,99999);
		$js->timerlocation("window", "/glquesti/default/calcquestiontree?specialid=". $specialid ."&courseid=". $courseid ."&rnum=". $rnum, 1);
	}

	//统计各节点题目数量
	public function actionCalcquestiontree(){
		$lastgetid = $this->request->get("lastgetid");
		$lastgetid = htmlspecialchars(strip_tags(trim($lastgetid)));
		if(empty($lastgetid) || is_numeric($lastgetid)==false){
			$lastgetid = 0;
		}

		$allrecordsize = $this->request->get("allrecordsize");
		$allrecordsize = htmlspecialchars(strip_tags(trim($allrecordsize)));
		$completedsize = $this->request->get("completedsize");
		$completedsize = htmlspecialchars(strip_tags(trim($completedsize)));

		$condition = "1=1";

		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(!empty($specialid) && is_numeric($specialid)){
			$condition .= " and specialid=". $specialid;
		}

		$courseid = $this->request->get("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(!empty($courseid) && is_numeric($courseid)){
			$condition .= " and courseid=". $courseid;
		}

		if(empty($allrecordsize) || is_numeric($allrecordsize)==false){
			$allrecordsize = Resour_tree::find()->where($condition)->count();
		}
		if(empty($completedsize) || is_numeric($completedsize)==false){
			$completedsize = 0;
		}

		$alltrees = Resour_tree::find()->where($condition ." and id>". $lastgetid)->orderby("id asc")->limit(30)->all();
		if(empty($alltrees)){
			echo '<script language="javascript">parent.location.reload();</script>';
			die();
		}
		foreach ($alltrees as $onetree) {
			echo $onetree->id .', '. $onetree->name .'<br>';
			$lastgetid = $onetree->id;
			$completedsize ++;
			$questinum = Questi_stem::find()->where("find_in_set('". $onetree->id ."',treepath)")->count();
			$onetree->questinum = $questinum;
			$onetree->save();
		}
		if($allrecordsize>0){
			$progress = round($completedsize/$allrecordsize*100,2);
			echo '<script language="javascript">parent.$("#progressbox").find("div").css("width","'. $progress .'%").attr("lay-percent","'. $progress .'%");parent.$("#progressbox").find("span").html("'. $progress .'%");</script>';
		}
		$js = new JsHelper();
		$rnum = date("YmdHis") . rand(10000,99999);
		$js->timerlocation("window", "/glquesti/default/calcquestiontree?lastgetid=". $lastgetid ."&allrecordsize=". $allrecordsize ."&completedsize=". $completedsize ."&specialid=". $specialid ."&courseid=". $courseid ."&rnum=". $rnum, 1);
	}
		
}
?>