<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Specialty;
use app\models\Questi_stem;
use app\models\Questi_type;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class ListController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glquesti";
		$this->view->params["navicode_two"] = "glquesti_manage";
		$this->view->params["meta_title"] = "题库管理 - ";
		return true;
	}
		
	//题目列表
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			WarningHelper::warning("课程不存在",""); die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$leadcourseids = $this->userobj->leadcourseidszyk;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false && stripos(",". $leadcourseids .",", ",". $course->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_username = $this->request->post("se_username");
		$se_username = htmlspecialchars(strip_tags(trim($se_username)));

		$se_treeid = $this->request->post("se_treeid");
		$se_treeid = htmlspecialchars(strip_tags(trim($se_treeid)));
		
		$se_typechild = $this->request->post("se_typechild");
		$se_typechild = htmlspecialchars(strip_tags(trim($se_typechild)));
		
		$se_levels = $this->request->post("se_levels");
		$se_levels = htmlspecialchars(strip_tags(trim($se_levels)));

		$se_islocked = $this->request->post("se_islocked");
		$se_islocked = htmlspecialchars(strip_tags(trim($se_islocked)));

		$se_orderby = $this->request->post("se_orderby");
		$se_orderby = htmlspecialchars(strip_tags(trim($se_orderby)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "courseid=". $course->id;
		if(!empty($se_title)){
			$condition .= " and content like '%". $se_title ."%'";
		}
		if(!empty($se_username)){
			$condition .= " and userid in (select id from user where realname like '%". $se_username ."%')";
		}
		if(!empty($se_treeid) && is_numeric($se_treeid)){
			$condition .= " and find_in_set('". $se_treeid ."',treepath)";
		}
		if(!empty($se_typechild) && is_numeric($se_typechild)){
			$condition .= " and typechild=". $se_typechild;
		}
		if(!empty($se_levels) && is_numeric($se_levels)){
			$condition .= " and levels=". $se_levels;
		}
		if($se_islocked==1){
			$condition .= " and islocked=1";
		}elseif($se_islocked==2){
			$condition .= " and islocked=0";
		}
		$allsize = Questi_stem::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$resources = Questi_stem::find()->select("id,userid,typeid,typechild,courseid,treeid,levels,cometime,content,islocked")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["resources"=>$resources]);
		}else{
			$chapters = Resour_tree::find()->select("id,name,questinum")->where("courseid=". $course->id ." and parentid=0")->orderby("sortid asc,id asc")->all();
			foreach ($chapters as $onechapter) {
				$onechapter->sections = Resour_tree::find()->select("id,name,questinum")->where("parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
				foreach ($onechapter->sections as $onesection) {
					$onesection->knowledges = Resour_tree::find()->select("id,name,questinum")->where("parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
				}
			}
			$questitypes = Questi_type::find()->where("parentid>0")->orderby("sortid asc,id asc")->all();
			$zerotree = Resour_tree::find()->where("courseid=". $course->id ." and parentid>0")->one();
			if(empty($zerotree)){ $zerotree = new Resour_tree(); $zerotree->id = 0; }
			if($this->userobj->roleid!=1){
				$meleader = Resour_leader::find()->where("courseid=". $course->id ." and userid=". $this->userobj->id)->one();
				if(!empty($meleader)){
					$this->view->params["navicode_two"] = "glquesti_myqbank";
				}
			}
			return $this->render("index", ["course"=>$course, "chapters"=>$chapters, "specialty"=>$specialty, "pager"=>$pager, "questitypes"=>$questitypes, "zerotree"=>$zerotree, "search"=>["se_title"=>$se_title, "se_username"=>$se_username, "se_treeid"=>$se_treeid, "se_typechild"=>$se_typechild, "se_levels"=>$se_levels, "se_orderby"=>$se_orderby, "se_islocked"=>$se_islocked]]);
		}
	}
		
}
?>