<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Questi_stem;
use app\components\WarningHelper;
use app\components\AccessControl;

class MovetoController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//移动题目
	public function actionIndex(){
		$courseid = $this->request->get("courseid");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(!empty($courseid) && is_numeric($courseid)){
			$course = Resour_course::find()->where("id=". $courseid)->one();
			if(empty($course)){
				echo "课程不存在"; die();
			}
			$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		}else{
			if(!empty($specialid) && is_numeric($specialid)){
				$specialty = Specialty::find()->where("id=". $specialid)->one();
			}else{
				echo '参数错误'; die();
			}
		}
		if(empty($specialty)){
			echo '专业不存在'; die();
		}
		if(empty($course)){
			$course = Resour_course::find()->where("specialid=". $specialty->id)->one();
		}
		$allcourses = Resour_course::find()->where("specialid=". $specialty->id)->all();
		$se_courseid = $this->request->post("se_courseid");
		$se_courseid = htmlspecialchars(strip_tags(trim($se_courseid)));
		if(empty($se_courseid) || !is_numeric($se_courseid)){
			$se_courseid = $course->id;
		}
		$chapters = Resour_tree::find()->select("id,name,questinum")->where("courseid=". $se_courseid ." and parentid=0")->orderby("sortid asc,id asc")->all();
		foreach ($chapters as $onechapter) {
			$onechapter->sections = Resour_tree::find()->select("id,name,questinum")->where("parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
			foreach ($onechapter->sections as $onesection) {
				$onesection->knowledges = Resour_tree::find()->select("id,name,questinum")->where("parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
			}
		}
		return $this->renderPartial("index", ["courseid"=>$courseid, "specialid"=>$specialid, "allcourses"=>$allcourses, "chapters"=>$chapters, "se_courseid"=>$se_courseid]);
	}
	
	//移动题目，保存
	public function actionMovetook(){
		$se_courseid = $this->request->post("se_courseid");
		$se_courseid = htmlspecialchars(strip_tags(trim($se_courseid)));
		$se_treeid = $this->request->post("se_treeid");
		$se_treeid = htmlspecialchars(strip_tags(trim($se_treeid)));
		$resourceids = $this->request->post("resourceids");
		$resourceids = htmlspecialchars(strip_tags(trim($resourceids)));
		if(empty($se_courseid) || is_numeric($se_courseid)==false){
			echo json_encode(["code"=>"failed","msg"=>"课程参数错误"]);
			die();
		}
		$course = Resour_course::find()->where("id=". $se_courseid)->one();
		if(empty($course)){
			echo json_encode(["code"=>"failed","msg"=>"课程不存在"]);
			die();
		}
		if(empty($se_treeid) || is_numeric($se_treeid)==false){
			echo json_encode(["code"=>"failed","msg"=>"知识点参数错误"]);
			die();
		}
		$tree = Resour_tree::find()->where("id=". $se_treeid)->one();
		if(empty($tree)){
			echo json_encode(["code"=>"failed","msg"=>"知识点不存在"]);
			die();
		}
		if(empty($resourceids)){
			echo json_encode(["code"=>"failed","msg"=>"没有选择题目"]);
			die();
		}
		Questi_stem::updateAll(["courseid"=>$se_courseid, "treeid"=>$se_treeid, "treepath"=>$tree->nodepath], "id in (". $resourceids .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>