<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SafetyHelper;

class ResourceController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//题目管理
	public function actionIndex(){
		$treeid = $this->request->get("id");
		$treeid = htmlspecialchars(strip_tags(trim($treeid)));
		if(empty($treeid) || is_numeric($treeid)==false){
			echo '参数错误'; die();
		}
		$resources = Questi_stem::find()->where("treeid=". $treeid)->orderby("id desc")->all();
		return $this->renderPartial("index", ["resources"=>$resources]);
	}

	//删除题目
	public function actionDelete(){
		$resouridarr = $this->request->post("resourid");
		if(empty($resouridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($resouridarr as $oneresourid) {
			if(empty($oneresourid) || !is_numeric($oneresourid)){
				$oneresourid = 0;
			}
			$oneresourid = SafetyHelper::KillDangerCode($oneresourid);
			$oneresourid = htmlspecialchars(strip_tags(trim($oneresourid)));
		}
		$resouridstr = implode(",", $resouridarr);
		Questi_option::deleteAll("stemid in (". $resouridstr .")");
		Questi_stem::deleteAll("id in (". $resouridstr .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//上下移动题目
	public function actionMoveupdown(){
		$resourid = $this->request->post("resourid");
		$resourid = htmlspecialchars(strip_tags(trim($resourid)));
		$direction = $this->request->post("direction");
		$direction = htmlspecialchars(strip_tags(trim($direction)));
		if(empty($resourid) || is_numeric($resourid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$resource = Questi_stem::find()->where("id=". $resourid)->one();
		if(empty($resource)){
			echo json_encode(["code"=>"failed","msg"=>"题目不存在"]);
			die();
		}
		$brothers = Questi_stem::find()->where("courseid=". $resource->courseid ." and treeid=". $resource->treeid)->orderby("sortid asc,id asc")->all();
		foreach($brothers as $onekey => $onebrother){
			$onebrother->sortid = ($onekey+1)*10;
			if($direction=="up"){ //上移
				if($onebrother->id==$resource->id){
					if($onebrother->sortid<15){
						$onebrother->sortid = 1;
					}else{
						$onebrother->sortid -= 15;
					}
				}
			}else{ //下移
				if($onebrother->id==$resource->id){
					$onebrother->sortid += 15;
				}
			}
			$onebrother->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//禁用题目
	public function actionLocked(){
		$islocked = $this->request->post("islocked");
		$islocked = htmlspecialchars(strip_tags(trim($islocked)));
		$resouridarr = $this->request->post("resourid");
		if(empty($resouridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		if($islocked==1){
		}else{
			$islocked = 0;
		}
		foreach ($resouridarr as $oneresourid) {
			if(empty($oneresourid) || !is_numeric($oneresourid)){
				$oneresourid = 0;
			}
			$oneresourid = SafetyHelper::KillDangerCode($oneresourid);
			$oneresourid = htmlspecialchars(strip_tags(trim($oneresourid)));
		}
		$resouridstr = implode(",", $resouridarr);
		Questi_stem::updateAll(["islocked"=>$islocked], "id in (". $resouridstr .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>