<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Specialty;
use app\models\Questi_stem;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class SpecialController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glquesti";
		$this->view->params["navicode_two"] = "glquesti_manage";
		$this->view->params["meta_title"] = "题库管理 - ";
		return true;
	}
		
	//资源库课程
	public function actionIndex(){
		$specialid = $this->request->get("id");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($specialid) || is_numeric($specialid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "specialid=". $specialty->id;
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		$allsize = Resour_course::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$courses = Resour_course::find()->select("id,specialid,name,questinum,isopen,reusage")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["courses"=>$courses]);
		}else{
			return $this->render("index", ["specialty"=>$specialty, "pager"=>$pager, "userobj"=>$this->userobj, "search"=>["se_title"=>$se_title]]);
		}
	}

	//设置对学生开放
	public function actionChangeopen(){
		$courseid = $this->request->post("courseid");
		$isopen = $this->request->post("isopen");
		if(empty($courseid) || !is_numeric($courseid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($isopen) || !is_numeric($isopen)){
			$isopen = 0;
		}
		if($isopen==1){
			Resour_course::updateAll(["isopen"=>1], "id=". $courseid);
		}else{
			Resour_course::updateAll(["isopen"=>2], "id=". $courseid);
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//保存允许重复使用次数
	public function actionSaveusage(){
		$courseidarr = $this->request->post("courseid");
		$reusage = $this->request->post("reusage");
		if(empty($courseidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($courseidarr as $onekey => $onecourseid) {
			if(empty($onecourseid) || !is_numeric($onecourseid)){
				$onecourseid = 0;
			}
			$onecourseid = SafetyHelper::KillDangerCode($onecourseid);
			$onecourseid = htmlspecialchars(strip_tags(trim($onecourseid)));
			if(empty($reusage[$onekey]) || !is_numeric($reusage[$onekey])){
				$reusage[$onekey] = 0;
			}
			$reusage[$onekey] = SafetyHelper::KillDangerCode($reusage[$onekey]);
			$reusage[$onekey] = htmlspecialchars(strip_tags(trim($reusage[$onekey])));
			Resour_course::updateAll(["reusage"=>$reusage[$onekey]], "id=". $onecourseid);
			Questi_stem::updateAll(["maxreusage"=>$reusage[$onekey]], "courseid=". $onecourseid);
		}		
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//初始化题库
	public function actionInitialize(){
		$courseidarr = $this->request->post("courseid");
		if(empty($courseidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($courseidarr as $onekey => $onecourseid) {
			if(empty($onecourseid) || !is_numeric($onecourseid)){
				$onecourseid = 0;
			}
			$onecourseid = SafetyHelper::KillDangerCode($onecourseid);
			$onecourseid = htmlspecialchars(strip_tags(trim($onecourseid)));
		}
		$courseidstr = implode(",", $courseidarr);
		Questi_stem::updateAll(["reusage"=>0], "courseid in (". $courseidstr .")");	
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>