<?php
namespace app\modules\glquesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Questi_stem;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;

class TreeController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glquesti";
		$this->view->params["navicode_two"] = "glquesti_manage";
		$this->view->params["meta_title"] = "题库管理 - ";
		return true;
	}
		
	//知识树
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			WarningHelper::warning("课程不存在",""); die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		if($this->userobj->roleid!=1){
			$leadspecialids = $this->userobj->leadspecialids;
			$leadcourseids = $this->userobj->leadcourseidszyk;
			if(stripos(",". $leadspecialids .",", ",". $specialty->id .",")===false && stripos(",". $leadcourseids .",", ",". $course->id .",")===false){
				WarningHelper::warning("无权访问",""); die();
			}
		}
		$chapters = Resour_tree::find()->where("courseid=". $course->id ." and parentid=0")->orderby("sortid asc,id asc")->all();
		foreach ($chapters as $onechapter) {
			$onechapter->sections = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
			$onechapter->questistems = Questi_stem::find()->where("courseid=". $course->id ." and treeid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
			foreach ($onechapter->sections as $onesection) {
				$onesection->knowledges = Resour_tree::find()->where("courseid=". $course->id ." and parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
				$onesection->questistems = Questi_stem::find()->where("courseid=". $course->id ." and treeid=". $onesection->id)->orderby("sortid asc,id asc")->all();
				foreach ($onesection->knowledges as $oneknowled) {
					$oneknowled->questistems = Questi_stem::find()->where("courseid=". $course->id ." and treeid=". $oneknowled->id)->orderby("sortid asc,id asc")->all();
				}
			}
		}
		$treepath = $this->request->post("treepath");
		$treepath = htmlspecialchars(strip_tags(trim($treepath)));
		if($this->userobj->roleid!=1){
			$meleader = Resour_leader::find()->where("courseid=". $course->id ." and userid=". $this->userobj->id)->one();
			if(!empty($meleader)){
				$this->view->params["navicode_two"] = "glquesti_myqbank";
			}
		}
		return $this->render("index", ["specialty"=>$specialty, "course"=>$course, "chapters"=>$chapters, "treepath"=>$treepath]);
	}
		
}
?>