<?php
namespace app\modules\glspecial\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\PinyinHelper;
use app\components\WarningHelper;
use app\components\AccessControl;

class KnowledController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑专业
	public function actionIndex(){
		$knowledid = $this->request->get("id");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		$parentid = $this->request->get("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo "参数错误"; die();
		}
		if(empty($knowledid) || is_numeric($knowledid)==false){
			$knowled = new Specialty();
			$knowled->parentid = $parentid;
			$section = Specialty::find()->where("id=". $parentid)->one();
			$treepath = $section->nodepath;
		}else{
			$knowled = Specialty::find()->where("id=". $knowledid)->one();
			if(empty($knowled)){
				echo "专业不存在"; die();
			}
			$treepath = $knowled->nodepath;
		}
		return $this->renderPartial("index", ["knowled"=>$knowled, "treepath"=>$treepath]);
	}
	
	//编辑专业，保存
	public function actionBasicok(){
		$knowledid = $this->request->post("knowledid");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$parentid = $this->request->post("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$section = Specialty::find()->where("id=". $parentid)->one();
		if(empty($section)){
			echo json_encode(["code"=>"failed","msg"=>"系不存在"]);
			die();
		}
		if(empty($knowledid) || is_numeric($knowledid)==false){
			$knowled = new Specialty();
		    $knowled->parentid = $section->id;
		    $knowled->nodetype = 3;
			$knowled->cometime = date("Y-m-d H:i:s");
			$isnewnode = 1;
			$sameone = Specialty::find()->where("name='". $title ."'")->one();
		}else{
			$knowled = Specialty::find()->where("id=". $knowledid)->one();
			$isnewnode = 0;
			$sameone = Specialty::find()->where("name='". $title ."' and id<>". $knowledid)->one();
		}
		if(!empty($sameone)){
			echo json_encode(["code"=>"failed","msg"=>"名称已被占用"]);
			die();
		}
		$pinyin = new PinyinHelper();
		$knowled->name = $title;
		$knowled->spelling = $pinyin->getAllPY($knowled->name);
		if(stripos($knowled->name,"会计")!==false){
			$knowled->spelling = str_ireplace("huiji", "kuaiji", $knowled->spelling);
		}
		$knowled->firstletter = substr($knowled->spelling,0,1);
		$knowled->firstletter = strtoupper($knowled->firstletter);
		$knowled->save();
		if($isnewnode==1){
			$knowled->nodepath = ",". $section->parentid .",". $section->id .",". $knowled->id .",";
			$knowled->sortid = $knowled->id*10;
			$knowled->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除专业
	public function actionDelete(){
		$knowledid = $this->request->post("knowledid");
		$knowledid = htmlspecialchars(strip_tags(trim($knowledid)));
		if(empty($knowledid) || is_numeric($knowledid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		Specialty_leader::deleteAll("specialid=". $knowledid);
		Specialty::deleteAll("find_in_set('". $knowledid ."',nodepath) or id=". $knowledid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>