<?php
namespace app\modules\glspecial\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;

class LeaderController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//团队成员
	public function actionIndex(){
		$specialid = $this->request->get("id");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($specialid) || is_numeric($specialid)==false){
			echo '参数错误'; die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			echo '专业不存在'; die();
		}
		$leaders = Specialty_leader::find()->where("specialid=". $specialid)->orderby("leadertype asc")->all();
		return $this->renderPartial("index", ["specialty"=>$specialty, "leaders"=>$leaders]);
	}

	//删除成员
	public function actionDelete(){
		$leaderidarr = $this->request->post("leaderid");
		if(empty($leaderidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($leaderidarr as $oneleaderid) {
			if(empty($oneleaderid) || !is_numeric($oneleaderid)){
				$oneleaderid = 0;
			}
			$oneleaderid = SafetyHelper::KillDangerCode($oneleaderid);
			$oneleaderid = htmlspecialchars(strip_tags(trim($oneleaderid)));
		}
		$leaderidstr = implode(",", $leaderidarr);
		Specialty_leader::deleteAll("id in (". $leaderidstr .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//设置负责人
	public function actionChange(){
		$specialid = $this->request->post("specialid");
		$leaderid = $this->request->post("leaderid");
		$leadertype = $this->request->post("leadertype");
		if(empty($specialid) || !is_numeric($specialid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($leaderid) || !is_numeric($leaderid)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if(empty($leadertype) || !is_numeric($leadertype)){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if($leadertype==1){
			Specialty_leader::updateAll(["leadertype"=>2], "specialid=". $specialid);
			Specialty_leader::updateAll(["leadertype"=>1], "id=". $leaderid);
		}else{
			Specialty_leader::updateAll(["leadertype"=>2], "id=". $leaderid);
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>