<?php
namespace app\modules\glspecial\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\components\UserHelper;
use app\extensions\pager\Pager;

class LeaderaddController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}

	//添加成员
	public function actionIndex(){
		$specialid = $this->request->get("id");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($specialid) || is_numeric($specialid)==false){
			echo '参数错误'; die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			echo '专业不存在'; die();
		}
		
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "roleid in (3)";
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_title)){
			$condition .= " and (username like '%". $se_title ."%' or stdnumber like '%". $se_title ."%' or realname like '%". $se_title ."%')";
		}
		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$users = User::find()->select("id,roleid,username,stdnumber,male,realname,regtime,logintime,logo,islocked,specialid,specialpath")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["users"=>$users]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->renderPartial("index", ["pager"=>$pager, "specialty"=>$specialty, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_specialid"=>$se_specialid]]);
		}
	}

	//添加成员保存
	public function actionAddok(){
		$specialid = $this->request->post("specialid");
		$useridarr = $this->request->post("userid");
		if(empty($specialid) || is_numeric($specialid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			echo json_encode(["code"=>"failed", "msg"=>"院系专业不存在"]);
			die();
		}
		if(empty($useridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($useridarr as $oneuserid) {
			if(empty($oneuserid) || !is_numeric($oneuserid)){
				$oneuserid = 0;
			}
			$oneuserid = SafetyHelper::KillDangerCode($oneuserid);
			$oneuserid = htmlspecialchars(strip_tags(trim($oneuserid)));
		}
		$useridstr = implode(",", $useridarr);
		$users = User::find()->where("id in (". $useridstr .")")->all();
		foreach ($users as $oneuser) {
			$oneleader = Specialty_leader::find()->where("specialid=". $specialty->id ." and userid=". $oneuser->id)->one();
			if(empty($oneleader)){
				$oneleader = new Specialty_leader();
				$oneleader->specialid = $specialty->id;
				$oneleader->specialtype = $specialty->nodetype;
				$oneleader->userid = $oneuser->id;
				$oneleader->leadertype = 2;
			}
			$oneleader->username = $oneuser->username;
			$oneleader->stdnumber = $oneuser->stdnumber;
			$oneleader->realname = $oneuser->realname;
			$oneleader->logo = $oneuser->logo;
			$oneleader->save();
			$leadspecialids = UserHelper::getLeadSpecialIds($oneuser->id);
			$oneuser->leadspecialids = ",". $leadspecialids .",";
			$oneuser->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>