<?php
namespace app\modules\glspecial\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\models\Specialty_leader;
use app\components\PinyinHelper;
use app\components\WarningHelper;
use app\components\AccessControl;

class SectionController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑系
	public function actionIndex(){
		$sectionid = $this->request->get("id");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		$parentid = $this->request->get("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo "参数错误"; die();
		}
		if(empty($sectionid) || is_numeric($sectionid)==false){
			$section = new Specialty();
			$section->parentid = $parentid;
			$chapter = Specialty::find()->where("id=". $parentid)->one();
			$treepath = $chapter->nodepath;
		}else{
			$section = Specialty::find()->where("id=". $sectionid)->one();
			if(empty($section)){
				echo "系不存在"; die();
			}
			$treepath = $section->nodepath;
		}
		return $this->renderPartial("index", ["section"=>$section, "treepath"=>$treepath]);
	}
	
	//编辑系，保存
	public function actionBasicok(){
		$sectionid = $this->request->post("sectionid");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$parentid = $this->request->post("parentid");
		$parentid = htmlspecialchars(strip_tags(trim($parentid)));
		if(empty($parentid) || is_numeric($parentid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$chapter = Specialty::find()->where("id=". $parentid)->one();
		if(empty($chapter)){
			echo json_encode(["code"=>"failed","msg"=>"院不存在"]);
			die();
		}
		if(empty($sectionid) || is_numeric($sectionid)==false){
			$section = new Specialty();
		    $section->parentid = $chapter->id;
		    $section->nodetype = 2;
			$section->cometime = date("Y-m-d H:i:s");
			$isnewnode = 1;
			$sameone = Specialty::find()->where("name='". $title ."'")->one();
		}else{
			$section = Specialty::find()->where("id=". $sectionid)->one();
			$isnewnode = 0;
			$sameone = Specialty::find()->where("name='". $title ."' and id<>". $sectionid)->one();
		}
		if(!empty($sameone)){
			echo json_encode(["code"=>"failed","msg"=>"名称已被占用"]);
			die();
		}
		$pinyin = new PinyinHelper();
		$section->name = $title;
		$section->spelling = $pinyin->getAllPY($section->name);
		if(stripos($section->name,"会计")!==false){
			$section->spelling = str_ireplace("huiji", "kuaiji", $section->spelling);
		}
		$section->firstletter = substr($section->spelling,0,1);
		$section->firstletter = strtoupper($section->firstletter);
		$section->save();
		if($isnewnode==1){
			$section->nodepath = ",". $chapter->id .",". $section->id .",";
			$section->sortid = $section->id*10;
			$section->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//删除系
	public function actionDelete(){
		$sectionid = $this->request->post("sectionid");
		$sectionid = htmlspecialchars(strip_tags(trim($sectionid)));
		if(empty($sectionid) || is_numeric($sectionid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		Specialty_leader::deleteAll("specialid=". $sectionid);
		Specialty::deleteAll("find_in_set('". $sectionid ."',nodepath) or id=". $sectionid);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>