<?php
namespace app\modules\gluser\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\models\Role;
use app\models\Doexam;
use app\models\Specialty;
use app\models\Resour_leader;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\UserHelper;
use app\components\SpecialtyHelper;

class BasicController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "gluser";
		$this->view->params["navicode_two"] = "gluser_manage";
		$this->view->params["meta_title"] = "用户管理 - ";
		return true;
	}
	
	//编辑用户
	public function actionIndex(){
		$userid = $this->request->get("id");
		$userid = htmlspecialchars(strip_tags(trim($userid)));
		if(empty($userid) || !is_numeric($userid)){
			$user = new User();
			$user->roleid = 4;
		}else{
			$user = User::find()->where("id=". $userid)->one();
			if(empty($user)){
				WarningHelper::warning("用户不存在", ""); die();
			}
		}
		$roles = Role::find()->where("id in (3,4,5,6)")->all();
		$colleges = SpecialtyHelper::getCollegelistall();
		return $this->render("index", ["user"=>$user, "roles"=>$roles, "colleges"=>$colleges]);
	}

	//编辑用户，保存
	public function actionBasicok(){
		$userid = $this->request->post("userid");
		$userid = htmlspecialchars(strip_tags(trim($userid)));
		$roleid = $this->request->post("roleid");
		$roleid = htmlspecialchars(strip_tags(trim($roleid)));
		$specialid = $this->request->post("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		$xzclassid = $this->request->post("xzclassid");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$username = $this->request->post("username");
		$username = htmlspecialchars(strip_tags(trim($username)));
		$password = $this->request->post("password");
		$password = htmlspecialchars(strip_tags(trim($password)));
		$realname = $this->request->post("realname");
		$realname = htmlspecialchars(strip_tags(trim($realname)));
		$stdnumber = $this->request->post("stdnumber");
		$stdnumber = htmlspecialchars(strip_tags(trim($stdnumber)));
		$logo = $this->request->post("logo");
		$logo = htmlspecialchars(strip_tags(trim($logo)));
		$male = $this->request->post("male");
		$male = htmlspecialchars(strip_tags(trim($male)));
		$cellphone = $this->request->post("cellphone");
		$cellphone = htmlspecialchars(strip_tags(trim($cellphone)));
		$email = $this->request->post("email");
		$email = htmlspecialchars(strip_tags(trim($email)));

		if(empty($username)){
			echo json_encode(["code"=>"failed", "msg"=>"用户名不能为空"]);
			die();
		}
		$json = UserHelper::sameUsername($username, $userid);
		$result = json_decode($json);
		if($result->code!="success"){
			echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
			die();
		}
		if(empty($userid) && empty($password)){
			echo json_encode(["code"=>"failed", "msg"=>"密码不能为空"]);
			die();
		}
		if(empty($realname)){
			echo json_encode(["code"=>"failed", "msg"=>"姓名不能为空"]);
			die();
		}
		if(empty($stdnumber)){
			echo json_encode(["code"=>"failed", "msg"=>"学号不能为空"]);
			die();
		}
		$json = UserHelper::sameStdnumber($stdnumber, $userid);
		$result = json_decode($json);
		if($result->code!="success"){
			echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
			die();
		}
		if(empty($logo)){
			$logo = "";
		}
		if($male==1 || $male==2){
			//do nothing
		}else{
			$male = 0;
		}
		if(!empty($cellphone)){
			$json = UserHelper::sameCellphone($cellphone, $userid);
			$result = json_decode($json);
			if($result->code!="success"){
				echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
				die();
			}
		}
		if(!empty($email)){
			$json = UserHelper::sameEmailbox($email, $userid);
			$result = json_decode($json);
			if($result->code!="success"){
				echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
				die();
			}
		}
		if(!empty($specialid) && is_numeric($specialid)){
			$specialty = Specialty::find()->where("nodetype=3 and id=". $specialid)->one();
			if(empty($specialty)){
				echo json_encode(["code"=>"failed", "msg"=>"所属专业错误"]);
				die();
			}
			$specialpath = $specialty->nodepath;
		}else{
			$specialid = 0;
			$specialpath = "";
		}
		if(empty($xzclassid) || is_numeric($xzclassid)==false){
			$xzclassid = 0;
		}
		if(empty($userid) || is_numeric($userid)==false){
			if($roleid==3 || $roleid==4 || $roleid==5 || $roleid==6){
				//...
			}else{
				echo json_encode(["code"=>"failed", "msg"=>"用户角色错误"]);
				die();
			}
			$user = new User();
			$user->roleid = $roleid;
			$user->groupid = $roleid;
			$user->salt = md5(uniqid(md5(microtime(true)),true));
			$user->regtime = date("Y-m-d H:i:s");
			$user->regip = $this->request->getUserIP();
			$user->isactive = 1;
			$user->token = md5(uniqid(md5(microtime(true)),true));
			$user->leadspecialids = ",0,";
			$user->leadcourseidszyk = ",0,";
		}else{
			$user = User::find()->where("id=". $userid)->one();
			if(empty($user)){
				echo json_encode(["code"=>"failed", "msg"=>"用户不存在"]);
				die();
			}
		}
		$user->username = $username;
		$user->realname = $realname;
		$user->stdnumber = $stdnumber;
		if(!empty($password)){
			$user->password = md5($password . $user->salt);
		}
		$user->male = $male;
		$user->logo = $logo;
		$user->cellphone = $cellphone;
		$user->email = $email;
		$user->specialid = $specialid;
		$user->specialpath = $specialpath;
		$user->xzclassid = $xzclassid;
		$user->save();
		Doexam::updateAll(["username"=>$user->username,"stdnumber"=>$user->stdnumber,"realname"=>$user->realname],"userid=". $user->id);
		Resour_leader::updateAll(["username"=>$user->username,"stdnumber"=>$user->stdnumber,"realname"=>$user->realname,"logo"=>$user->logo],"userid=". $user->id);
		Specialty_leader::updateAll(["username"=>$user->username,"stdnumber"=>$user->stdnumber,"realname"=>$user->realname,"logo"=>$user->logo],"userid=". $user->id);
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}

	//删除头像
	public function actionDeletelogo(){
		$userid = $this->request->post("userid");
		$userid = htmlspecialchars(strip_tags(trim($userid)));
		if(empty($userid) || is_numeric($userid)==false){
			echo json_encode(array("code"=>"failed","msg"=>"参数错误"));
			die();
		}else{
			$user = User::find()->where("id=". $userid)->one();
		}
		if(empty($user)){
			echo json_encode(array("code"=>"failed","msg"=>"用户不存在"));
			die();
		}
		if(!empty($user->logo)){
			if(file_exists(WEBROOT . $user->logo)){
				unlink(WEBROOT . $user->logo);
			}
			$logo_b = str_ireplace("_s.", ".", $user->logo);
			if(file_exists(WEBROOT . $logo_b)){
				unlink(WEBROOT . $logo_b);
			}
		}
		$user->logo = "";
		$user->save();
		Resour_leader::updateAll(["logo"=>$user->logo],"userid=". $user->id);
		Specialty_leader::updateAll(["logo"=>$user->logo],"userid=". $user->id);
		echo json_encode(array("code"=>"success","msg"=>"成功"));
	}
		
}
?>