<?php
namespace app\modules\gluser\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\models\Role;
use app\models\Specialty;
use app\models\Schoolclass;
use app\models\Resour_leader;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "gluser";
		$this->view->params["navicode_two"] = "gluser_manage";
		$this->view->params["meta_title"] = "用户管理 - ";
		return true;
	}
	
	public function actionIndex(){
		$se_roleid = $this->request->post("se_roleid");
		$se_roleid = htmlspecialchars(strip_tags(trim($se_roleid)));
		
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));

		$se_xzclassid = $this->request->post("se_xzclassid");
		$se_xzclassid = htmlspecialchars(strip_tags(trim($se_xzclassid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_islocked = $this->request->post("se_islocked");
		$se_islocked = htmlspecialchars(strip_tags(trim($se_islocked)));

		$se_isactive = $this->request->post("se_isactive");
		$se_isactive = htmlspecialchars(strip_tags(trim($se_isactive)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "roleid in (3,4,5,6) and isarchived=0";
		if(!empty($se_roleid) && is_numeric($se_roleid)){
			$condition .= " and roleid=". $se_roleid;
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_xzclassid) && is_numeric($se_xzclassid)){
			$condition .= " and xzclassid=". $se_xzclassid;
		}
		if(!empty($se_title)){
			$condition .= " and (username like '%". $se_title ."%' or stdnumber like '%". $se_title ."%' or realname like '%". $se_title ."%')";
		}
		if($se_islocked==1){
			$condition .= " and islocked=1";
		}elseif($se_islocked==2){
			$condition .= " and islocked=0";
		}
		if($se_isactive==1){
			$condition .= " and isactive=1";
		}elseif($se_isactive==2){
			$condition .= " and isactive=0";
		}
		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$users = User::find()->select("id,roleid,username,stdnumber,male,realname,regtime,logintime,logo,islocked,isactive,specialid,specialpath,xzclassid")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["users"=>$users]);
		}else{
			$roles = Role::find()->where("id in (3,4,5,6)")->all();
			$colleges = SpecialtyHelper::getCollegelistall();
			$xzclasses = [];
			if(!empty($se_specialid) && is_numeric($se_specialid)){
				$xzclasses = Schoolclass::find()->select("id,name")->where("find_in_set('". $se_specialid ."',specialpath)")->orderby("spelling asc")->all();
			}
			return $this->render("index", ["pager"=>$pager, "roles"=>$roles, "colleges"=>$colleges, "xzclasses"=>$xzclasses, "search"=>["se_title"=>$se_title, "se_islocked"=>$se_islocked, "se_roleid"=>$se_roleid, "se_specialid"=>$se_specialid, "se_xzclassid"=>$se_xzclassid, "se_isactive"=>$se_isactive]]);
		}
	}

	//删除用户
	public function actionDelete(){
		$useridarr = $this->request->post("userid");
		if(empty($useridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($useridarr as $oneuserid) {
			if(empty($oneuserid) || !is_numeric($oneuserid)){
				$oneuserid = 0;
			}
			$oneuserid = SafetyHelper::KillDangerCode($oneuserid);
			$oneuserid = htmlspecialchars(strip_tags(trim($oneuserid)));
		}
		$useridstr = implode(",", $useridarr);
		Resour_leader::deleteAll("userid in (". $useridstr .")");
		Specialty_leader::deleteAll("userid in (". $useridstr .")");
		User::deleteAll("id in (". $useridstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//审核账号
	public function actionActive(){
		$useridarr = $this->request->post("userid");
		if(empty($useridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		$doisactive = $this->request->post("doisactive");
		if($doisactive==1){
			//do nothing
		}else{
			$doisactive = 0;
		}
		foreach ($useridarr as $oneuserid) {
			if(empty($oneuserid) || !is_numeric($oneuserid)){
				$oneuserid = 0;
			}
			$oneuserid = SafetyHelper::KillDangerCode($oneuserid);
			$oneuserid = htmlspecialchars(strip_tags(trim($oneuserid)));
		}
		$useridstr = implode(",", $useridarr);
		User::updateAll(["isactive"=>$doisactive], "id in (". $useridstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//锁定账号
	public function actionLocked(){
		$useridarr = $this->request->post("userid");
		if(empty($useridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		$doislocked = $this->request->post("doislocked");
		if($doislocked==1){
			//do nothing
		}else{
			$doislocked = 0;
		}
		foreach ($useridarr as $oneuserid) {
			if(empty($oneuserid) || !is_numeric($oneuserid)){
				$oneuserid = 0;
			}
			$oneuserid = SafetyHelper::KillDangerCode($oneuserid);
			$oneuserid = htmlspecialchars(strip_tags(trim($oneuserid)));
		}
		$useridstr = implode(",", $useridarr);
		User::updateAll(["islocked"=>$doislocked], "id in (". $useridstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//根据专业切换班级
	public function actionXzclasslist(){
		$specialid = $this->request->post("specialid");
		$xzclassid = $this->request->post("xzclassid");
		if(empty($specialid) || !is_numeric($specialid)){
			echo '<option>参数错误</option>';
			die();
		}
		$html = '<option>请选择</option>';
		$xzclasses = Schoolclass::find()->select("id,name")->where("find_in_set('". $specialid ."',specialpath)")->orderby("spelling asc")->all();
		foreach ($xzclasses as $oneclass) {
			$html .= '<option value="'. $oneclass->id .'"';
			if($xzclassid==$oneclass->id){
				$html .= ' selected';
			}
			$html .= '>'. $oneclass->name .'</option>';
		}
		echo $html;
	}
	
}
?>