<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Exam;
use app\models\User;
use app\models\Schoolclass;
use app\models\Specialty;
use app\models\Resour_leader;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class ArchiveController extends Controller
{
	
	private $userobj; //班级登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glxzclass";
		$this->view->params["navicode_two"] = "glxzclass_archive";
		$this->view->params["meta_title"] = "班级管理 - ";
		return true;
	}
	
	public function actionIndex(){		
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_grade = $this->request->post("se_grade");
		$se_grade = htmlspecialchars(strip_tags(trim($se_grade)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "isarchived>0";
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if(!empty($se_grade) && is_numeric($se_grade)){
			$condition .= " and grade=". $se_grade;
		}
		$allsize = Schoolclass::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$xzclasses = Schoolclass::find()->select("id,specialid,name,studentnum,grade,specialpath")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["xzclasses"=>$xzclasses]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_grade"=>$se_grade, "se_specialid"=>$se_specialid]]);
		}
	}

	//恢复班级
	public function actionRecover(){
		$xzclassidarr = $this->request->post("xzclassid");
		if(empty($xzclassidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($xzclassidarr as $oneclassid) {
			if(empty($oneclassid) || !is_numeric($oneclassid)){
				$oneclassid = 0;
			}
			$oneclassid = SafetyHelper::KillDangerCode($oneclassid);
			$oneclassid = htmlspecialchars(strip_tags(trim($oneclassid)));
			Exam::updateAll(["isarchived"=>0], "find_in_set('". $oneclassid ."',forclass)");
		}
		$xzclassidstr = implode(",", $xzclassidarr);
		Doexam::updateAll(["isarchived"=>0], "xzclassid in (". $xzclassidstr .")");
		User::updateAll(["isarchived"=>0], "xzclassid in (". $xzclassidstr .")");
		Schoolclass::updateAll(["isarchived"=>0], "id in (". $xzclassidstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//删除班级
	public function actionDelete(){
		$xzclassidarr = $this->request->post("xzclassid");
		if(empty($xzclassidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($xzclassidarr as $oneclassid) {
			if(empty($oneclassid) || !is_numeric($oneclassid)){
				$oneclassid = 0;
			}
			$oneclassid = SafetyHelper::KillDangerCode($oneclassid);
			$oneclassid = htmlspecialchars(strip_tags(trim($oneclassid)));
		}
		$xzclassidstr = implode(",", $xzclassidarr);
		User::deleteAll("xzclassid in (". $xzclassidstr .")");
		Schoolclass::deleteAll("id in (". $xzclassidstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}
	
}
?>