<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Schoolclass;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\PinyinHelper;
use app\components\SpecialtyHelper;

class BasicController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//编辑班级
	public function actionIndex(){
		$xzclassid = $this->request->get("id");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		if(empty($xzclassid) || is_numeric($xzclassid)==false){
			$schoolclass = new Schoolclass();
		}else{
			$schoolclass = Schoolclass::find()->where("id=". $xzclassid)->one();
			if(empty($schoolclass)){
				echo "班级不存在"; die();
			}
		}
		if(empty($specialid) || is_numeric($specialid)==false){
			$specialid = 0;
		}
		$colleges = SpecialtyHelper::getCollegelistall();
		return $this->renderPartial("index", ["schoolclass"=>$schoolclass, "colleges"=>$colleges, "specialid"=>$specialid]);
	}
	
	//编辑班级，保存
	public function actionBasicok(){
		$xzclassid = $this->request->post("xzclassid");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$specialid = $this->request->post("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		$grade = $this->request->post("grade");
		$grade = htmlspecialchars(strip_tags(trim($grade)));
		if(empty($specialid) || is_numeric($specialid)==false){
			echo json_encode(["code"=>"failed","msg"=>"参数错误"]);
			die();
		}
		$specialty = Specialty::find()->where("id=". $specialid)->one();
		if(empty($specialty)){
			echo json_encode(["code"=>"failed","msg"=>"专业不存在"]);
			die();
		}
		if(empty($grade) || is_numeric($grade)==false){
			$grade = date("Y");
		}
		if(empty($xzclassid) || is_numeric($xzclassid)==false){
			$schoolclass = new Schoolclass();
			$schoolclass->cometime = date("Y-m-d H:i:s");
		}else{
			$schoolclass = Schoolclass::find()->where("id=". $xzclassid)->one();
		}
		$pinyin = new PinyinHelper();
		$schoolclass->specialid = $specialty->id;
		$schoolclass->specialpath = $specialty->nodepath;
		$schoolclass->grade = $grade;
		$schoolclass->name = $title;
		$schoolclass->spelling = $pinyin->getAllPY($schoolclass->name);
		if(stripos($schoolclass->name,"会计")!==false){
			$schoolclass->spelling = str_ireplace("huiji", "kuaiji", $schoolclass->spelling);
		}
		$schoolclass->firstletter = substr($schoolclass->spelling,0,1);
		$schoolclass->firstletter = strtoupper($schoolclass->firstletter);
		$schoolclass->save();
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>