<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Exam;
use app\models\User;
use app\models\Schoolclass;
use app\models\Specialty;
use app\models\Resour_leader;
use app\models\Specialty_leader;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //班级登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glxzclass";
		$this->view->params["navicode_two"] = "glxzclass_manage";
		$this->view->params["meta_title"] = "班级管理 - ";
		return true;
	}
	
	public function actionIndex(){		
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_grade = $this->request->post("se_grade");
		$se_grade = htmlspecialchars(strip_tags(trim($se_grade)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "isarchived=0";
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if(!empty($se_grade) && is_numeric($se_grade)){
			$condition .= " and grade=". $se_grade;
		}
		$allsize = Schoolclass::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$xzclasses = Schoolclass::find()->select("id,specialid,name,studentnum,grade,specialpath")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["xzclasses"=>$xzclasses]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_grade"=>$se_grade, "se_specialid"=>$se_specialid]]);
		}
	}

	//存档班级
	public function actionArchive(){
		$xzclassidarr = $this->request->post("xzclassid");
		if(empty($xzclassidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($xzclassidarr as $oneclassid) {
			if(empty($oneclassid) || !is_numeric($oneclassid)){
				$oneclassid = 0;
			}
			$oneclassid = SafetyHelper::KillDangerCode($oneclassid);
			$oneclassid = htmlspecialchars(strip_tags(trim($oneclassid)));
			Exam::updateAll(["isarchived"=>date("Y")], "find_in_set('". $oneclassid ."',forclass)");
		}
		$xzclassidstr = implode(",", $xzclassidarr);
		Doexam::updateAll(["isarchived"=>date("Y")], "xzclassid in (". $xzclassidstr .")");
		User::updateAll(["isarchived"=>date("Y")], "xzclassid in (". $xzclassidstr .")");
		Schoolclass::updateAll(["isarchived"=>date("Y")], "id in (". $xzclassidstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//删除班级
	public function actionDelete(){
		$xzclassidarr = $this->request->post("xzclassid");
		if(empty($xzclassidarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($xzclassidarr as $oneclassid) {
			if(empty($oneclassid) || !is_numeric($oneclassid)){
				$oneclassid = 0;
			}
			$oneclassid = SafetyHelper::KillDangerCode($oneclassid);
			$oneclassid = htmlspecialchars(strip_tags(trim($oneclassid)));
		}
		$xzclassidstr = implode(",", $xzclassidarr);
		User::deleteAll("xzclassid in (". $xzclassidstr .")");
		Schoolclass::deleteAll("id in (". $xzclassidstr .")");
		echo json_encode(["code"=>"success", "msg"=>"成功"]);
	}

	//统计学生数量
	public function actionCalcstudentnum(){
		$specialid = $this->request->get("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		$xzclassid = $this->request->get("xzclassid");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$dbh = Yii::$app->db;
		$sql = "update specialty set studentnum=(select count(*) from user where user.specialid=specialty.id) where nodetype=3";
		if(!empty($specialid) && is_numeric($specialid)){
			$sql .= " and id=". $specialid;
		}
		$sql .= ";update specialty set studentnum=0 where studentnum is null;";
		$cmd = $dbh->createCommand($sql);
		$cmd->execute();
		$sql = "update schoolclass set studentnum=(select count(*) from user where user.xzclassid=schoolclass.id) where 1=1";
		if(!empty($xzclassid) && is_numeric($xzclassid)){
			$sql .= " and id=". $xzclassid;
		}
		$sql .= ";update schoolclass set studentnum=0 where studentnum is null;";
		$cmd = $dbh->createCommand($sql);
		$cmd->execute();
		$progress = 100;
		echo '<script language="javascript">parent.$("#progressbox").find("div").css("width","'. $progress .'%").attr("lay-percent","'. $progress .'%");parent.$("#progressbox").find("span").html("'. $progress .'%");</script>';
		echo '<script language="javascript">parent.location.reload();</script>';
	}
	
}
?>