<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\models\User;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class MovetoController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20;
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//移动学生
	public function actionIndex(){
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_grade = $this->request->post("se_grade");
		$se_grade = htmlspecialchars(strip_tags(trim($se_grade)));

		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "1=1";
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if(!empty($se_grade) && is_numeric($se_grade)){
			$condition .= " and grade=". $se_grade;
		}
		$allsize = Schoolclass::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$xzclasses = Schoolclass::find()->select("id,specialid,name,studentnum,grade,specialpath")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["xzclasses"=>$xzclasses]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->renderPartial("index", ["pager"=>$pager, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_grade"=>$se_grade, "se_specialid"=>$se_specialid]]);
		}
	}
	
	//移动学生，保存
	public function actionMovetook(){
		$xzclassid = $this->request->post("xzclassid");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$resourceids = $this->request->post("resourceids");
		$resourceids = htmlspecialchars(strip_tags(trim($resourceids)));
		if(empty($xzclassid) || is_numeric($xzclassid)==false){
			echo json_encode(["code"=>"failed","msg"=>"班级参数错误"]);
			die();
		}
		$schoolclass = Schoolclass::find()->where("id=". $xzclassid)->one();
		if(empty($schoolclass)){
			echo json_encode(["code"=>"failed","msg"=>"班级不存在"]);
			die();
		}
		if(empty($resourceids)){
			echo json_encode(["code"=>"failed","msg"=>"没有选择学生"]);
			die();
		}
		User::updateAll(["xzclassid"=>$xzclassid, "specialid"=>$schoolclass->specialid, "specialpath"=>$schoolclass->specialpath], "id in (". $resourceids .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>