<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Schoolclass;
use app\models\Specialty;
use app\models\User;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class StudentController extends Controller
{
	
	private $userobj; //班级登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glxzclass";
		$this->view->params["navicode_two"] = "glxzclass_manage";
		$this->view->params["meta_title"] = "班级管理 - ";
		return true;
	}
	
	public function actionIndex(){		
		$classid = $this->request->get("id");
		$classid = htmlspecialchars(strip_tags(trim($classid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		if(empty($classid) || !is_numeric($classid)){
			WarningHelper::warning("参数错误", "");
			die();
		}
		$schoolclass = Schoolclass::find()->where("id=". $classid)->one();
		if(empty($schoolclass)){
			WarningHelper::warning("班级不存在", "");
			die();
		}
		if($schoolclass->isarchived>0){
			$this->view->params["navicode_two"] = "glxzclass_archive";
		}

		$condition = "xzclassid=". $classid;
		if(!empty($se_title)){
			$condition .= " and (username like '%". $se_title ."%' or stdnumber like '%". $se_title ."%' or realname like '%". $se_title ."%')";
		}
		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$users = User::find()->select("id,specialid,username,stdnumber,realname,male,regtime,logintime")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["users"=>$users]);
		}else{
			return $this->render("index", ["pager"=>$pager, "schoolclass"=>$schoolclass, "search"=>["se_title"=>$se_title]]);
		}
	}
	
}
?>