<?php
namespace app\modules\glxzclass\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\models\Role;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SafetyHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class UseraddController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}

	//添加成员
	public function actionIndex(){
		$classid = $this->request->get("id");
		$classid = htmlspecialchars(strip_tags(trim($classid)));
		if(empty($classid) || is_numeric($classid)==false){
			echo '参数错误'; die();
		}
		$xzclass = Schoolclass::find()->where("id=". $classid)->one();
		if(empty($xzclass)){
			echo '班级不存在'; die();
		}

		$se_roleid = $this->request->post("se_roleid");
		$se_roleid = htmlspecialchars(strip_tags(trim($se_roleid)));
		
		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "roleid in (3,4,5,6) and isarchived=0";
		if(!empty($se_roleid) && is_numeric($se_roleid)){
			$condition .= " and roleid=". $se_roleid;
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_title)){
			$condition .= " and (username like '%". $se_title ."%' or stdnumber like '%". $se_title ."%' or realname like '%". $se_title ."%')";
		}
		$allsize = User::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize	= $allsize;  //总记录条数
		$pager->pagesize = $this->pagesize;  //每页数量
		$pager->get_pagerinfo();

		if($listmore=="yes"){
			$users = User::find()->select("id,roleid,username,stdnumber,male,realname,regtime,logintime,logo,islocked,specialid,specialpath")->where($condition)->orderby("id desc")->offset(($curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["users"=>$users]);
		}else{
			$roles = Role::find()->where("id in (3,4,5,6)")->all();
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->renderPartial("index", ["pager"=>$pager, "xzclass"=>$xzclass, "roles"=>$roles, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_specialid"=>$se_specialid, "se_roleid"=>$se_roleid]]);
		}
	}

	//添加成员保存
	public function actionAddok(){
		$classid = $this->request->post("classid");
		$useridarr = $this->request->post("userid");
		if(empty($classid) || is_numeric($classid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		$xzclass = Schoolclass::find()->where("id=". $classid)->one();
		if(empty($xzclass)){
			echo json_encode(["code"=>"failed", "msg"=>"班级不存在"]);
			die();
		}
		if(empty($useridarr)){
			echo json_encode(["code"=>"failed", "msg"=>"您还没有选择"]);
			die();
		}
		foreach ($useridarr as $oneuserid) {
			if(empty($oneuserid) || !is_numeric($oneuserid)){
				$oneuserid = 0;
			}
			$oneuserid = SafetyHelper::KillDangerCode($oneuserid);
			$oneuserid = htmlspecialchars(strip_tags(trim($oneuserid)));
		}
		$useridstr = implode(",", $useridarr);
		User::updateAll(["xzclassid"=>$classid], "id in (". $useridstr .")");
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
}
?>