<?php
namespace app\modules\lequesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Resour_leader;
use app\models\Specialty;
use app\models\Questi_stem;
use app\models\Questi_type;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\extensions\pager\Pager;

class ListController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "lequesti";
		$this->view->params["navicode_two"] = "lequesti_myqbank";
		$this->view->params["meta_title"] = "题库学习 - ";
		return true;
	}
		
	//题目列表
	public function actionIndex(){
		$courseid = $this->request->get("id");
		$courseid = htmlspecialchars(strip_tags(trim($courseid)));
		if(empty($courseid) || is_numeric($courseid)==false){
			WarningHelper::warning("参数错误",""); die();
		}
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(empty($course)){
			WarningHelper::warning("课程不存在",""); die();
		}
		if($course->isopen!=1){
			WarningHelper::warning("题库未开放",""); die();
		}
		$specialty = Specialty::find()->where("id=". $course->specialid)->one();
		if(empty($specialty)){
			WarningHelper::warning("专业不存在",""); die();
		}
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_treeid = $this->request->post("se_treeid");
		$se_treeid = htmlspecialchars(strip_tags(trim($se_treeid)));
		
		$se_typeid = $this->request->post("se_typeid");
		$se_typeid = htmlspecialchars(strip_tags(trim($se_typeid)));
		
		$se_levels = $this->request->post("se_levels");
		$se_levels = htmlspecialchars(strip_tags(trim($se_levels)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "courseid=". $course->id ." and islocked=0";
		if(!empty($se_title)){
			$condition .= " and content like '%". $se_title ."%'";
		}
		if(!empty($se_treeid) && is_numeric($se_treeid)){
			$condition .= " and find_in_set('". $se_treeid ."',treepath)";
		}
		if(!empty($se_typeid) && is_numeric($se_typeid)){
			$condition .= " and typeid=". $se_typeid;
		}
		if(!empty($se_levels) && is_numeric($se_levels)){
			$condition .= " and levels=". $se_levels;
		}
		$allsize = Questi_stem::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$resources = Questi_stem::find()->select("id,userid,typeid,typechild,courseid,treeid,levels,cometime,content")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["resources"=>$resources]);
		}else{
			$chapters = Resour_tree::find()->where("courseid=". $course->id ." and parentid=0")->orderby("sortid asc,id asc")->all();
			foreach ($chapters as $onechapter) {
				$onechapter->sections = Resour_tree::find()->where("parentid=". $onechapter->id)->orderby("sortid asc,id asc")->all();
				foreach ($onechapter->sections as $onesection) {
					$onesection->knowledges = Resour_tree::find()->where("parentid=". $onesection->id)->orderby("sortid asc,id asc")->all();
				}
			}
			$questitypes = Questi_type::find()->where("parentid>0")->orderby("sortid asc,id asc")->all();
			return $this->render("index", ["course"=>$course, "chapters"=>$chapters, "specialty"=>$specialty, "pager"=>$pager, "questitypes"=>$questitypes, "search"=>["se_title"=>$se_title, "se_treeid"=>$se_treeid, "se_typeid"=>$se_typeid, "se_levels"=>$se_levels]]);
		}
	}
		
}
?>