<?php
namespace app\modules\lequesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class MyqbankController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "lequesti";
		$this->view->params["navicode_two"] = "lequesti_myqbank";
		$this->view->params["meta_title"] = "题库学习 - ";
		return true;
	}
		
	//资源库课程
	public function actionIndex(){
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "isopen=1";
		if(!empty($se_title)){
			$condition .= " and name like '%". $se_title ."%'";
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		$allsize = Resour_course::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$courses = Resour_course::find()->select("id,specialid,name,questinum,isopen")->where($condition)->orderby("id desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			return $this->renderPartial("pagelist", ["courses"=>$courses]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "search"=>["se_title"=>$se_title, "se_specialid"=>$se_specialid]]);
		}
	}
		
}
?>