<?php
namespace app\modules\lequesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Exam;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\components\WarningHelper;
use app\components\AccessControl;

class PreviewController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
	
	//预览题目
	public function actionIndex(){
		$condition = "ispublish=1 and begintime<='". date("Y-m-d H:i:s") ."' and endtime>='". date("Y-m-d H:i:s") ."'";
		$condition .= " and find_in_set('". $this->userobj->xzclassid ."',forclass)";
		$exam = Exam::find()->where($condition)->one();
		if(!empty($exam)){
			echo '有考试正在进行，暂停浏览...'; die();
		}
		$resourceid = $this->request->get("id");
		$resourceid = htmlspecialchars(strip_tags(trim($resourceid)));
		if(empty($resourceid) || is_numeric($resourceid)==false){
			echo '参数错误'; die();
		}
		$resource = Questi_stem::find()->where("id=". $resourceid)->one();
		if(empty($resource)){
			echo '题目不存在'; die();
		}
		$resource->options = Questi_option::find()->where("stemid=". $resource->id)->orderby("code asc")->all();
		return $this->renderPartial("index", ["resource"=>$resource]);
	}
	
}
?>