<?php
namespace app\modules\lequesti\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour_course;
use app\models\Resour_tree;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\components\WarningHelper;
use app\components\AccessControl;

class ResourceController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		return true;
	}
		
	//题目管理
	public function actionIndex(){
		$treeid = $this->request->get("id");
		$treeid = htmlspecialchars(strip_tags(trim($treeid)));
		if(empty($treeid) || is_numeric($treeid)==false){
			echo '参数错误'; die();
		}
		$resources = Questi_stem::find()->where("treeid=". $treeid ." and islocked=0")->orderby("id desc")->all();
		return $this->renderPartial("index", ["resources"=>$resources]);
	}
	
}
?>