<?php
namespace app\modules\lespecial\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "lespecial";
		$this->view->params["navicode_two"] = "lespecial_manage";
		$this->view->params["meta_title"] = "院系专业";
		return true;
	}
		
	//行政结构树
	public function actionIndex(){
		$chapters = Specialty::find()->where("parentid=0")->orderby("spelling asc")->all();
		foreach ($chapters as $onechapter) {
			$onechapter->children = Specialty::find()->where("parentid=". $onechapter->id)->orderby("spelling asc")->all();
			foreach ($onechapter->children as $onesection) {
				$onesection->children = Specialty::find()->where("parentid=". $onesection->id)->orderby("spelling asc")->all();
			}
		}
		$treepath = $this->request->post("treepath");
		$treepath = htmlspecialchars(strip_tags(trim($treepath)));
		return $this->render("index", ["chapters"=>$chapters, "treepath"=>$treepath]);
	}
		
}
?>