<?php
namespace app\modules\user\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\components\AccessControl;
use app\components\AuthcodeHelper;

class ChanpassController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
  	public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "changepa";
		return true;
	}
	
	public function actionIndex(){
		return $this->render("index");
	}

	//修改密码，保存
	public function actionBasicok(){
		$oldpassw = $this->request->post("oldpassw");
		$oldpassw = htmlspecialchars(strip_tags(trim($oldpassw)));
		$newpassw = $this->request->post("newpassw");
		$newpassw = htmlspecialchars(strip_tags(trim($newpassw)));

		if(empty($oldpassw)){
			$result = ["code"=>"failed", "msg"=>"请填写旧密码"];
			echo json_encode($result); die();
		}
		if(empty($newpassw)){
			$result = ["code"=>"failed", "msg"=>"请填写新密码"];
			echo json_encode($result); die();
		}
		$user = User::find()->where("id=". $this->userobj->id)->one();
		if(empty($user)){
			$result = ["code"=>"failed", "msg"=>"用户不存在"];
			echo json_encode($result); die();
		}
		if(md5($oldpassw . $user->salt)!=$user->password){
			$result = ["code"=>"failed", "msg"=>"旧密码错误"];
			echo json_encode($result); die();
		}
		$user->password = md5($newpassw . $user->salt);
		$user->save();
		$result = ["code"=>"success", "msg"=>"成功"];
		echo json_encode($result);
	}
	
}
?>