<?php
namespace app\modules\user\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Notice;
use app\models\Exam;
use app\models\Doexam;
use app\components\AccessControl;
use app\components\UserHelper;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "user_home";
		return true;
	}
	
	public function actionIndex(){
		$condition = "ispublish=1 and find_in_set('". $this->userobj->xzclassid ."',forclass)";
		$exams_canjia = Exam::find()->select("id,userid,specialid,courseid,title,points,begintime,endtime,ispublish,specialpath,questway")->where($condition)->orderby("begintime desc")->limit(5)->all();
		foreach ($exams_canjia as $oneexam) {
			$oneexam->doexam = Doexam::find()->where("examid=". $oneexam->id ." and userid=". $this->userobj->id)->one();
		}
		$exams_fabu = [];
		if($this->userobj->roleid==1 || $this->userobj->roleid==3){
			$condition = "ispublish=1";
			if($this->userobj->roleid!=1){
				$leadcourseids = $this->userobj->leadcourseidszyk;
				$condition .= " and courseid in (". $leadcourseids .")";
			}
			$exams_fabu = Exam::find()->select("id,userid,specialid,courseid,title,points,begintime,endtime,ispublish,specialpath,questway")->where($condition)->orderby("begintime desc")->limit(5)->all();
		}
		return $this->render("index", ["exams_canjia"=>$exams_canjia, "exams_fabu"=>$exams_fabu, "userobj"=>$this->userobj]);
	}
	
}
?>